/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueue;
import com.caucho.env.actor.ValueActorQueue;
import com.caucho.message.nautilus.NautilusRingItem;
import com.caucho.util.RingItem;

class NautilusCheckpointPublisher {
    private ActorQueue<NautilusRingItem> _nautilusQueue;
    private ValueActorQueue<Long> _checkpointQueue;

    NautilusCheckpointPublisher(ActorQueue<NautilusRingItem> nautilusQueue) {
        this._nautilusQueue = nautilusQueue;
        this._checkpointQueue = new ValueActorQueue(256, new ActorProcessor[]{new CheckpointProcessor()});
    }

    boolean checkpoint(long blockAddress) {
        boolean isValid = this._checkpointQueue.offer((Object)new Long(blockAddress), false);
        this._checkpointQueue.wake();
        return isValid;
    }

    class CheckpointProcessor
    extends AbstractActorProcessor<Long> {
        CheckpointProcessor() {
        }

        public String getThreadName() {
            return ((Object)((Object)this)).toString();
        }

        public void process(Long blockAddress) throws Exception {
            NautilusRingItem entry = (NautilusRingItem)NautilusCheckpointPublisher.this._nautilusQueue.startOffer(true);
            entry.initCheckpoint(blockAddress, 0, 0);
            NautilusCheckpointPublisher.this._nautilusQueue.finishOffer((RingItem)entry);
            NautilusCheckpointPublisher.this._nautilusQueue.wake();
        }

        public void onProcessComplete() throws Exception {
        }
    }
}

