/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.message.nautilus.MessageDataNode;
import java.io.IOException;
import java.io.InputStream;

class MessageDataInputStream
extends InputStream {
    private MessageDataNode _head;
    private int _offset;
    private byte[] _buffer = new byte[1];

    MessageDataInputStream(MessageDataNode head) {
        this._head = head;
    }

    @Override
    public int read() throws IOException {
        int len = this.read(this._buffer, 0, 1);
        if (len > 0) {
            return this._buffer[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen;
        int nodeOffset;
        MessageDataNode head = this._head;
        if (head == null) {
            return -1;
        }
        int nodeLength = head.getLength();
        if (nodeLength <= (nodeOffset = this._offset)) {
            this._offset = 0;
            head = head.getNext();
            this._head = null;
            if (head == null) {
                return -1;
            }
            nodeLength = head.getLength();
            nodeOffset = 0;
        }
        if (length < (sublen = nodeLength - nodeOffset)) {
            sublen = length;
        }
        head.read(nodeOffset, buffer, offset, sublen);
        this._offset += sublen;
        return sublen;
    }
}

