/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.common;

import com.caucho.message.MessagePropertiesFactory;
import com.caucho.message.common.NullMessageFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class AbstractQueueSender<T>
implements BlockingQueue<T> {
    private static final MessagePropertiesFactory<?> NULL_FACTORY = new NullMessageFactory();

    protected abstract boolean offerMicros(MessagePropertiesFactory<T> var1, T var2, long var3);

    protected MessagePropertiesFactory<T> getMessageFactory() {
        return NULL_FACTORY;
    }

    @Override
    public boolean add(T value) {
        return this.offer(value);
    }

    @Override
    public boolean offer(T value) {
        MessagePropertiesFactory<T> factory = this.getMessageFactory();
        return this.offerMicros(factory, value, 0L);
    }

    @Override
    public boolean offer(T value, long timeout, TimeUnit timeUnit) {
        MessagePropertiesFactory<T> factory = this.getMessageFactory();
        return this.offerMicros(factory, value, timeUnit.toMicros(timeout));
    }

    @Override
    public void put(T value) throws InterruptedException {
        MessagePropertiesFactory<T> factory = this.getMessageFactory();
        this.offerMicros(factory, value, 0L);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        return false;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public T poll(long arg0, TimeUnit arg1) throws InterruptedException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T take() throws InterruptedException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T poll() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public <X> X[] toArray(X[] arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int drainTo(Collection<? super T> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int drainTo(Collection<? super T> arg0, int arg1) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

