/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.broker;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.message.DistributionMode;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.MessageBroker;
import com.caucho.message.broker.ReceiverMessageHandler;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.LruCache;
import java.util.Map;

public class EnvironmentMessageBroker
implements MessageBroker {
    private static final EnvironmentLocal<EnvironmentMessageBroker> _localBroker = new EnvironmentLocal();
    private ClassLoader _loader;
    private String _id;
    private ConcurrentArrayList<MessageBroker> _brokerList = new ConcurrentArrayList(MessageBroker.class);
    private LruCache<String, MessageBroker> _brokerMap = new LruCache(1024);

    private EnvironmentMessageBroker() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._id = Environment.getEnvironmentName((ClassLoader)this._loader);
        _localBroker.set((Object)this);
    }

    public static EnvironmentMessageBroker getCurrent() {
        return (EnvironmentMessageBroker)_localBroker.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvironmentMessageBroker create() {
        EnvironmentLocal<EnvironmentMessageBroker> environmentLocal = _localBroker;
        synchronized (environmentLocal) {
            EnvironmentMessageBroker broker = (EnvironmentMessageBroker)_localBroker.getLevel();
            if (broker == null) {
                broker = new EnvironmentMessageBroker();
                _localBroker.set((Object)broker);
            }
            return broker;
        }
    }

    public void addBroker(MessageBroker broker) {
        this._brokerList.add((Object)broker);
    }

    public void removeBroker(MessageBroker broker) {
        this._brokerList.remove((Object)broker);
    }

    public MessageBroker findBroker(Class<?> brokerClass) {
        for (MessageBroker broker : this._brokerList) {
            if (!brokerClass.isAssignableFrom(broker.getClass())) continue;
            return broker;
        }
        return null;
    }

    @Override
    public BrokerSender createSender(String name, Map<String, Object> properties) {
        MessageBroker broker = (MessageBroker)this._brokerMap.get((Object)name);
        if (broker != null) {
            return broker.createSender(name, properties);
        }
        for (MessageBroker registeredBroker : this._brokerList) {
            BrokerSender dest = registeredBroker.createSender(name, properties);
            if (dest == null) continue;
            this._brokerMap.put((Object)name, (Object)registeredBroker);
            return dest;
        }
        return null;
    }

    @Override
    public BrokerReceiver createReceiver(String name, DistributionMode distributionMode, Map<String, Object> properties, ReceiverMessageHandler listener) {
        for (MessageBroker registeredBroker : this._brokerList) {
            BrokerReceiver sub = registeredBroker.createReceiver(name, distributionMode, properties, listener);
            if (sub == null) continue;
            return sub;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._id + "]";
    }
}

