/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.memcached;

import com.caucho.distcache.ClusterCache;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.memcached.MemcachedProtocol;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class MemcachedConnection
extends AbstractProtocolConnection {
    private static final HashMap<CharBuffer, Command> _commandMap = new HashMap();
    private MemcachedProtocol _memcache;
    private ClusterCache _cache;
    private SocketLink _link;
    private CharBuffer _method = new CharBuffer();
    private SetInputStream _setInputStream = new SetInputStream();
    private GetOutputStream _getOutputStream = new GetOutputStream();
    private StringBuilder _sb = new StringBuilder();

    MemcachedConnection(MemcachedProtocol memcache, SocketLink link) {
        this._memcache = memcache;
        this._link = link;
        this._cache = memcache.getCache();
    }

    @Override
    public String getProtocolRequestURL() {
        return "memcache:";
    }

    @Override
    public void init() {
    }

    SocketLink getLink() {
        return this._link;
    }

    ReadStream getReadStream() {
        return this._link.getReadStream();
    }

    WriteStream getWriteStream() {
        return this._link.getWriteStream();
    }

    SetInputStream getSetInputStream() {
        return this._setInputStream;
    }

    GetOutputStream getGetOutputStream() {
        return this._getOutputStream;
    }

    ClusterCache getCache() {
        return this._cache;
    }

    @Override
    public boolean handleRequest() throws IOException {
        ReadStream is = this._link.getReadStream();
        while (this.handleSingleRequest(is)) {
            if (is.getBufferAvailable() > 0) continue;
            return true;
        }
        return false;
    }

    private boolean handleSingleRequest(ReadStream is) throws IOException {
        int ch;
        this._method.clear();
        while ((ch = is.read()) >= 0 && Character.isWhitespace(ch)) {
        }
        if (ch < 0) {
            return false;
        }
        do {
            this._method.append((char)ch);
        } while ((ch = is.read()) >= 0 && !Character.isWhitespace(ch));
        Command command = _commandMap.get(this._method);
        if (command == null) {
            WriteStream out = this.getWriteStream();
            out.print("ERROR\r\n");
            return true;
        }
        return command.execute(this);
    }

    @Override
    public boolean handleResume() throws IOException {
        return false;
    }

    @Override
    public boolean isWaitForRead() {
        return false;
    }

    @Override
    public void onCloseConnection() {
    }

    @Override
    public void onStartConnection() {
    }

    private static long getCasKey(HashKey valueKey) {
        if (valueKey == null) {
            return 0L;
        }
        byte[] valueHash = valueKey.getHash();
        return ((long)valueHash[0] & 0x7FL) << 56 | ((long)valueHash[1] & 0xFFL) << 48 | ((long)valueHash[2] & 0xFFL) << 40 | ((long)valueHash[3] & 0xFFL) << 32 | ((long)valueHash[4] & 0xFFL) << 24 | ((long)valueHash[5] & 0xFFL) << 16 | ((long)valueHash[6] & 0xFFL) << 8 | (long)valueHash[7] & 0xFFL;
    }

    static void addCommand(String name, Command command) {
        CharBuffer sb = new CharBuffer();
        sb.append(name);
        _commandMap.put(sb, command);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._link + "]";
    }

    static {
        MemcachedConnection.addCommand("add", new AddCommand());
        MemcachedConnection.addCommand("append", new AppendCommand());
        MemcachedConnection.addCommand("get", new GetCommand());
        MemcachedConnection.addCommand("gets", new GetCommand());
        MemcachedConnection.addCommand("get_if_modified", new GetIfModifiedCommand());
        MemcachedConnection.addCommand("decr", new DecrementCommand());
        MemcachedConnection.addCommand("delete", new DeleteCommand());
        MemcachedConnection.addCommand("incr", new IncrementCommand());
        MemcachedConnection.addCommand("prepend", new PrependCommand());
        MemcachedConnection.addCommand("quit", new QuitCommand());
        MemcachedConnection.addCommand("replace", new ReplaceCommand());
        MemcachedConnection.addCommand("set", new SetCommand());
        MemcachedConnection.addCommand("stats", new StatsCommand());
        MemcachedConnection.addCommand("version", new VersionCommand());
        MemcachedConnection.addCommand("verbosity", new VerbosityCommand());
    }

    static class CounterStream
    extends OutputStream {
        private int _sign = 1;
        private long _value;

        CounterStream() {
        }

        @Override
        public void write(int ch) {
            if (ch == 45) {
                this._sign = -1;
            }
            if (48 <= ch && ch <= 57) {
                this._value = 10L * this._value + (long)ch - 48L;
            }
        }

        public long getValue() {
            return (long)this._sign * this._value;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    static class GetOutputStream
    extends OutputStream {
        private WriteStream _os;

        GetOutputStream() {
        }

        void init(WriteStream os) {
            this._os = os;
        }

        @Override
        public final void write(int ch) throws IOException {
            this._os.write(ch);
        }

        @Override
        public final void write(byte[] buffer, int offset, int length) throws IOException {
            this._os.write(buffer, offset, length);
        }
    }

    static class SetInputStream
    extends InputStream {
        private ReadStream _is;
        private long _length;

        SetInputStream() {
        }

        void init(ReadStream is, long length) {
            this._is = is;
            this._length = length;
        }

        @Override
        public int read() throws IOException {
            if (this._length <= 0L) {
                return -1;
            }
            --this._length;
            return this._is.read();
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int readLength;
            if (this._length <= 0L) {
                return -1;
            }
            int sublen = (int)this._length;
            if (length < sublen) {
                sublen = length;
            }
            if ((readLength = this._is.read(buffer, offset, sublen)) <= 0) {
                return readLength;
            }
            this._length -= (long)readLength;
            return readLength;
        }
    }

    static class StatsCommand
    extends Command {
        StatsCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            ReadStream rs = conn.getReadStream();
            StringBuilder sb = new StringBuilder();
            int ch = rs.read();
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 10 && ch != 13 && ch != 32) {
                sb.append((char)ch);
                ch = rs.read();
            }
            while (ch >= 0 && ch != 10) {
                ch = rs.read();
            }
            WriteStream out = conn.getWriteStream();
            String key = sb.toString();
            if ("".equals(key)) {
                out.print("END\r\n");
            } else if ("resin".equals(key)) {
                this.printResinStats(out);
                out.print("END\r\n");
            } else {
                out.print("ERROR\r\n");
            }
            return true;
        }

        private void printResinStats(WriteStream out) throws IOException {
            out.print("STAT enable_get_if_modified 1\r\n");
        }
    }

    static class VerbosityCommand
    extends Command {
        VerbosityCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            int ch;
            ReadStream rs = conn.getReadStream();
            while ((ch = rs.read()) >= 0 && ch != 10) {
            }
            WriteStream out = conn.getWriteStream();
            out.print("OK\r\n");
            return true;
        }
    }

    static class VersionCommand
    extends Command {
        VersionCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            int ch;
            ReadStream rs = conn.getReadStream();
            while ((ch = rs.read()) >= 0 && ch != 10) {
            }
            WriteStream out = conn.getWriteStream();
            out.print("VERSION 1.4.0\r\n");
            return true;
        }
    }

    static class QuitCommand
    extends Command {
        QuitCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            WriteStream out = conn.getWriteStream();
            return false;
        }
    }

    static class DecrementCommand
    extends IncrementCommand {
        DecrementCommand() {
        }

        @Override
        protected long changeCache(ClusterCache cache, String key, long delta) throws IOException {
            return this.incrementCache(cache, key, -delta);
        }
    }

    static class IncrementCommand
    extends Command {
        IncrementCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            ReadStream rs = conn.getReadStream();
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            boolean isNoReply = false;
            CharBuffer cb = new CharBuffer();
            int ch = 0;
            ch = rs.read();
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 32 && ch != 10) {
                cb.append((char)ch);
                ch = rs.read();
            }
            String key = cb.toString();
            while (ch == 32) {
                ch = rs.read();
            }
            long delta = 0L;
            while (48 <= ch && ch <= 57) {
                delta = 10L * delta + (long)ch - 48L;
                ch = rs.read();
            }
            while (ch == 32) {
                ch = rs.read();
            }
            cb.clear();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10) {
                cb.append((char)ch);
                ch = rs.read();
            }
            if (cb.length() > 0 && cb.matches("noreply")) {
                isNoReply = true;
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                System.out.println("PROTOL: " + ch);
                throw new IOException("PROTOCOL: " + ch);
            }
            long value = this.changeCache(conn.getCache(), key, delta);
            if (!isNoReply) {
                if (value == Long.MIN_VALUE) {
                    out.print("NOT_FOUND\r\n");
                } else {
                    out.print("VALUE " + value + "\r\n");
                }
            }
            return true;
        }

        protected long changeCache(ClusterCache cache, String key, long delta) throws IOException {
            return this.incrementCache(cache, key, delta);
        }

        protected long incrementCache(ClusterCache cache, String key, long delta) throws IOException {
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            if (entry == null || entry.isValueNull()) {
                return Long.MIN_VALUE;
            }
            CounterStream os = new CounterStream();
            cache.get(key, os);
            long newValue = os.getValue() + delta;
            byte[] values = String.valueOf(newValue).getBytes();
            ByteArrayInputStream bis = new ByteArrayInputStream(values);
            cache.put(key, bis, entry.getAccessedExpireTimeout(), entry.getModifiedExpireTimeout());
            return newValue;
        }
    }

    static class DeleteCommand
    extends Command {
        DeleteCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            ReadStream rs = conn.getReadStream();
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            boolean isNoReply = false;
            CharBuffer cb = new CharBuffer();
            int ch = 0;
            ch = rs.read();
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 32 && ch != 10) {
                cb.append((char)ch);
                ch = rs.read();
            }
            String key = cb.toString();
            while (ch == 32) {
                ch = rs.read();
            }
            long time = 0L;
            while (48 <= ch && ch <= 57) {
                time = 10L * time + (long)ch - 48L;
                ch = rs.read();
            }
            while (ch == 32) {
                ch = rs.read();
            }
            cb.clear();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10) {
                cb.append((char)ch);
                ch = rs.read();
            }
            if (cb.length() > 0 && cb.matches("noreply")) {
                isNoReply = true;
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                System.out.println("PROTOL: " + ch);
                throw new IOException("PROTOCOL: " + ch);
            }
            if (this.deleteCache(conn.getCache(), time, key)) {
                if (!isNoReply) {
                    out.print("DELETED\r\n");
                }
            } else if (!isNoReply) {
                out.print("NOT_FOUND\r\n");
            }
            out.flush();
            return true;
        }

        protected boolean deleteCache(ClusterCache cache, long time, String key) throws IOException {
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            boolean isValue = entry != null && !entry.isValueNull();
            cache.remove(key);
            return isValue;
        }
    }

    static class GetIfModifiedCommand
    extends GetCommand {
        GetIfModifiedCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            ReadStream rs = conn.getReadStream();
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            StringBuilder sb = new StringBuilder();
            int ch = 0;
            ch = rs.read();
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 32 && ch != 10) {
                sb.append((char)ch);
                ch = rs.read();
            }
            while (ch == 32) {
                ch = rs.read();
            }
            long hash = 0L;
            while (48 <= ch && ch <= 57) {
                hash = 10L * hash + (long)ch - 48L;
                ch = rs.read();
            }
            this.getCache(out, conn.getCache(), sb.toString(), conn, hash);
            while (ch >= 0 && ch != 13 && ch != 10) {
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                System.out.println("PROTOL: " + ch);
                throw new IOException("PROTOCOL: " + ch);
            }
            out.print("END\r\n");
            out.flush();
            return true;
        }
    }

    static class GetCommand
    extends Command {
        GetCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            ReadStream rs = conn.getReadStream();
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            StringBuilder cb = conn._sb;
            cb.setLength(0);
            while (this.readKey(rs, cb)) {
                this.getCache(out, conn.getCache(), cb.toString(), conn, 0L);
            }
            int ch = rs.read();
            while (ch >= 0 && ch != 13 && ch != 10) {
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                System.out.println("PROTOL: " + ch);
                throw new IOException("PROTOCOL: " + ch);
            }
            out.print("END\r\n");
            return true;
        }

        private boolean readKey(ReadStream rs, StringBuilder cb) throws IOException {
            int ch;
            cb.setLength(0);
            while ((ch = rs.read()) >= 0 && ch == 32) {
            }
            if (ch < 0 || ch == 13 || ch == 10) {
                rs.unread();
                return false;
            }
            do {
                cb.append((char)ch);
            } while ((ch = rs.read()) >= 0 && ch != 32 && ch != 13 && ch != 10);
            rs.unread();
            return ch >= 0;
        }

        protected void getCache(WriteStream out, ClusterCache cache, String key, MemcachedConnection conn, long hash) throws IOException {
            ExtCacheEntry entry = cache.getLiveCacheEntry(key);
            if (entry == null) {
                return;
            }
            long valueHash = entry.getValueHash();
            if (valueHash == 0L) {
                return;
            }
            long now = CurrentTime.getCurrentTime();
            if (entry.isExpired(now)) {
                System.out.println("EXP: " + key.length());
                return;
            }
            long unique = valueHash;
            if (hash != 0L && hash == unique) {
                return;
            }
            out.print("VALUE ");
            out.print(key);
            out.print(" ");
            int flags = entry.getUserFlags();
            out.print(flags);
            long bytes = entry.getValueLength();
            out.print(" ");
            out.print(bytes);
            out.print("\r\n");
            if (!entry.readData((OutputStream)out, cache.getConfig())) {
                System.out.println("FAILED_WRITE:");
            }
            out.print("\r\n");
        }
    }

    static class PrependCommand
    extends StoreCommand {
        PrependCommand() {
        }

        @Override
        public boolean doCommand(MemcachedConnection conn, String key, long bytes, long timeout, int flags) throws IOException {
            ClusterCache cache = conn.getCache();
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            ReadStream rs = conn.getReadStream();
            if (entry == null || entry.isValueNull()) {
                rs.skip(bytes);
                return false;
            }
            TempStream ts = new TempStream();
            WriteStream os = new WriteStream((StreamImpl)ts);
            os.setDisableClose(true);
            SetInputStream setIs = conn.getSetInputStream();
            setIs.init(rs, bytes);
            os.writeStream((InputStream)setIs);
            cache.get(key, (OutputStream)os);
            os.setDisableClose(false);
            os.close();
            cache.put(key, (InputStream)ts.openRead(), entry.getAccessedExpireTimeout(), entry.getUserFlags());
            return true;
        }
    }

    static class AppendCommand
    extends StoreCommand {
        AppendCommand() {
        }

        @Override
        public boolean doCommand(MemcachedConnection conn, String key, long bytes, long timeout, int flags) throws IOException {
            ClusterCache cache = conn.getCache();
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            ReadStream rs = conn.getReadStream();
            if (entry == null || entry.isValueNull()) {
                rs.skip(bytes);
                return false;
            }
            TempStream ts = new TempStream();
            WriteStream os = new WriteStream((StreamImpl)ts);
            os.setDisableClose(true);
            cache.get(key, (OutputStream)os);
            SetInputStream setIs = conn.getSetInputStream();
            setIs.init(rs, bytes);
            os.writeStream((InputStream)setIs);
            os.setDisableClose(false);
            os.close();
            cache.put(key, (InputStream)ts.openRead(), entry.getAccessedExpireTimeout(), entry.getUserFlags());
            return true;
        }
    }

    static class ReplaceCommand
    extends StoreCommand {
        ReplaceCommand() {
        }

        @Override
        public boolean doCommand(MemcachedConnection conn, String key, long bytes, long timeout, int flags) throws IOException {
            ClusterCache cache = conn.getCache();
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            ReadStream rs = conn.getReadStream();
            if (entry == null || entry.isValueNull()) {
                rs.skip(bytes);
                return false;
            }
            SetInputStream setIs = conn.getSetInputStream();
            setIs.init(rs, bytes);
            cache.put(key, setIs, timeout, flags);
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            return true;
        }
    }

    static class AddCommand
    extends StoreCommand {
        AddCommand() {
        }

        @Override
        public boolean doCommand(MemcachedConnection conn, String key, long bytes, long timeout, int flags) throws IOException {
            ClusterCache cache = conn.getCache();
            ExtCacheEntry entry = cache.getExtCacheEntry(key);
            ReadStream rs = conn.getReadStream();
            if (entry != null && !entry.isValueNull()) {
                rs.skip(bytes);
                return false;
            }
            SetInputStream setIs = conn.getSetInputStream();
            setIs.init(rs, bytes);
            cache.put(key, setIs, timeout, flags);
            WriteStream out = conn.getWriteStream();
            out.setDisableClose(true);
            return true;
        }
    }

    static class SetCommand
    extends StoreCommand {
        SetCommand() {
        }

        @Override
        public boolean doCommand(MemcachedConnection conn, String key, long bytes, long expireTimeout, int flags) throws IOException {
            ReadStream rs = conn.getReadStream();
            SetInputStream setIs = conn.getSetInputStream();
            setIs.init(rs, bytes);
            ClusterCache cache = conn.getCache();
            cache.put(key, setIs, expireTimeout, expireTimeout, flags);
            return true;
        }
    }

    static abstract class StoreCommand
    extends Command {
        StoreCommand() {
        }

        @Override
        public boolean execute(MemcachedConnection conn) throws IOException {
            int ch;
            ReadStream rs = conn.getReadStream();
            WriteStream out = conn.getWriteStream();
            StringBuilder sb = new StringBuilder();
            while ((ch = rs.read()) >= 0 && ch == 32) {
            }
            if (ch < 0) {
                return false;
            }
            do {
                sb.append((char)ch);
            } while ((ch = rs.read()) >= 0 && ch != 32);
            String key = sb.toString();
            while ((ch = rs.read()) >= 0 && ch == 32) {
            }
            int flags = 0;
            while (48 <= ch && ch <= 57) {
                flags = 10 * flags + ch - 48;
                ch = rs.read();
            }
            long expTime = 0L;
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            while (48 <= ch && ch <= 57) {
                expTime = 10L * expTime + (long)ch - 48L;
                ch = rs.read();
            }
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            long bytes = 0L;
            while (48 <= ch && ch <= 57) {
                bytes = 10L * bytes + (long)ch - 48L;
                ch = rs.read();
            }
            while (ch >= 0 && ch == 32) {
                ch = rs.read();
            }
            sb.setLength(0);
            while (ch >= 0 && ch != 13) {
                sb.append((char)ch);
                ch = rs.read();
            }
            boolean isNoReply = sb.length() > 0 && "noreply".equals(sb.toString());
            ch = rs.read();
            if (ch != 10) {
                throw new IOException("PROTOCOL: " + ch);
            }
            long timeout = 60000L;
            timeout = expTime <= 0L ? 31536000000L : (expTime <= 2592000L ? 1000L * expTime : expTime * 1000L - CurrentTime.getCurrentTime());
            boolean isStored = this.doCommand(conn, key, bytes, timeout, flags);
            ch = rs.read();
            if (ch != 13) {
                out.println("PROTOCOL_ERROR");
                throw new IOException("PROTOCOL: " + ch);
            }
            ch = rs.read();
            if (ch != 10) {
                out.println("PROTOCOL_ERROR");
                throw new IOException("PROTOCOL: " + ch);
            }
            if (!isNoReply) {
                if (isStored) {
                    out.print("STORED\r\n");
                } else {
                    out.print("NOT_STORED\r\n");
                }
            }
            return true;
        }

        protected abstract boolean doCommand(MemcachedConnection var1, String var2, long var3, long var5, int var7) throws IOException;
    }

    static abstract class Command {
        Command() {
        }

        public abstract boolean execute(MemcachedConnection var1) throws IOException;

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

