/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.memcached;

import com.caucho.memcached.MemcachedClient;
import com.caucho.server.distcache.AbstractCacheEngine;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.HashKey;

public class MemcachedCacheEngine
extends AbstractCacheEngine {
    private CacheStoreManager _cacheService;
    private MemcachedClient _client;

    MemcachedCacheEngine(CacheStoreManager cacheService, MemcachedClient client) {
        this._cacheService = cacheService;
        this._client = client;
    }

    @Override
    public MnodeValue get(DistCacheEntry entry) {
        CharBuffer cb = new CharBuffer();
        Base64.encode((CharBuffer)cb, (byte[])entry.getKeyHash().getHash());
        String key = cb.toString();
        MnodeUpdate update = this._client.getResinIfModified(key, entry.getMnodeEntry().getValueHash(), entry);
        if (update != null) {
            return entry.putLocalValue(update, null);
        }
        return entry.getMnodeEntry();
    }

    @Override
    public void put(HashKey hashKey, HashKey cacheKey, MnodeUpdate mnodeUpdate, long valueDataId, long valueDataTime) {
        CharBuffer cb = new CharBuffer();
        Base64.encode((CharBuffer)cb, (byte[])hashKey.getHash());
        String key = cb.toString();
        this._client.putResin(key, mnodeUpdate, valueDataId);
    }

    @Override
    public void remove(HashKey hashKey, HashKey cacheKey, MnodeUpdate mnodeUpdate) {
        CharBuffer cb = new CharBuffer();
        Base64.encode((CharBuffer)cb, (byte[])hashKey.getHash());
        String key = cb.toString();
        this._client.removeImpl(key);
    }
}

