/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.cfg.TldAttribute;
import com.caucho.jsp.cfg.TldVariable;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.ArrayList;

public class JspDirectiveVariable
extends JspNode {
    private static final QName NAME_GIVEN = new QName("name-given");
    private static final QName NAME_FROM_ATTRIBUTE = new QName("name-from-attribute");
    private static final QName ALIAS = new QName("alias");
    private static final QName VARIABLE_CLASS = new QName("variable-class");
    private static final QName DECLARE = new QName("declare");
    private static final QName SCOPE = new QName("scope");
    private static final QName DESCRIPTION = new QName("description");
    static final L10N L = new L10N(JspDirectiveVariable.class);
    private String _nameGiven;
    private String _nameFromAttribute;
    private String _alias;
    private String _variableClass;
    private boolean _isDeclare = true;
    private String _scope;
    private String _description;

    @Override
    public void addAttribute(QName name, String value) throws JspParseException {
        if (!this._gen.getParseState().isTag()) {
            throw this.error(L.l("'{0}' is only allowed in .tag files.  Attribute directives are not allowed in normal JSP files.", (Object)this.getTagName()));
        }
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        if (NAME_GIVEN.equals((Object)name)) {
            if (gen.findVariable(value) != null) {
                throw this.error(L.l("@variable name-given '{0}' is already used by another variable.", (Object)value));
            }
            if (gen.findNameFromAttributeVariable(value) != null) {
                throw this.error(L.l("@variable name-from-attribute '{0}' is already used by another variable.", (Object)value));
            }
            if (gen.findAttribute(value) != null) {
                throw this.error(L.l("@variable name-given '{0}' is already used by an attribute.", (Object)value));
            }
            if (value.equals(gen.getDynamicAttributes())) {
                throw this.error(L.l("@variable name-given '{0}' cannot be the same as the tag's dynamic-attributes.", (Object)value));
            }
            this._nameGiven = value;
        } else if (NAME_FROM_ATTRIBUTE.equals((Object)name)) {
            if (gen.findVariable(value) != null) {
                throw this.error(L.l("@variable name-from-attribute '{0}' is already used by another variable.", (Object)value));
            }
            if (gen.findNameFromAttributeVariable(value) != null) {
                throw this.error(L.l("@variable name-from-attribute '{0}' is already used by another variable.", (Object)value));
            }
            this._nameFromAttribute = value;
        } else if (ALIAS.equals((Object)name)) {
            if (gen.findAttribute(value) != null) {
                throw this.error(L.l("@variable alias '{0}' is already used by an attribute.", (Object)value));
            }
            this._alias = value;
        } else if (VARIABLE_CLASS.equals((Object)name)) {
            this._variableClass = value;
        } else if (DECLARE.equals((Object)name)) {
            this._isDeclare = this.attributeToBoolean(name.getName(), value);
        } else if (SCOPE.equals((Object)name)) {
            if (!("NESTED".equals(value) || "AT_BEGIN".equals(value) || "AT_END".equals(value))) {
                throw this.error(L.l("'{0}' is an illegal scope value.  NESTED, AT_BEGIN, and AT_END are the only accepted values.", (Object)value));
            }
            this._scope = value;
        } else if (DESCRIPTION.equals((Object)name)) {
            this._description = value;
        } else {
            throw this.error(L.l("'{0}' is an unknown JSP variable directive attributes.  Valid attributes are: alias, declare, description, name-from-attribute, name-given, scope, variable-class.", (Object)name.getName()));
        }
    }

    @Override
    public void endElement() throws JspParseException {
        if (!this._gen.getParseState().isTag()) {
            throw this.error(L.l("'{0}' is only allowed in .tag files.  Variable directives are not allowed in normal JSP files.", (Object)this.getTagName()));
        }
        if (this._nameGiven == null && this._nameFromAttribute == null) {
            throw this.error(L.l("<{0}> needs a 'name-given' or 'name-from-attribute' attribute.", (Object)this.getTagName()));
        }
        if (this._nameFromAttribute != null && this._alias == null) {
            throw this.error(L.l("<{0}> needs an 'alias' attribute.  name-from-attribute requires an alias attribute.", (Object)this.getTagName()));
        }
        if (this._alias != null && this._nameFromAttribute == null) {
            throw this.error(L.l("<{0}> needs an 'name-from-attribute' attribute.  alias requires a name-from-attribute attribute.", (Object)this.getTagName()));
        }
        JavaTagGenerator tagGen = (JavaTagGenerator)this._gen;
        TldVariable var = new TldVariable();
        var.setNameGiven(this._nameGiven);
        var.setNameFromAttribute(this._nameFromAttribute);
        var.setAlias(this._alias);
        String name = this._nameGiven;
        if (name == null) {
            name = this._nameFromAttribute;
        }
        if (this._variableClass != null) {
            var.setVariableClass(this._variableClass);
        }
        var.setDeclare(this._isDeclare);
        if (this._scope != null) {
            var.setScope(this._scope);
        }
        tagGen.addVariable(var);
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:directive.variable");
        os.print(" jsp:id=\"" + this._gen.generateJspId() + "\"");
        if (this._nameGiven != null) {
            os.print(" name-given=\"" + this._nameGiven + "\"");
        }
        if (this._nameFromAttribute != null) {
            os.print(" name-from-attribute=\"" + this._nameFromAttribute + "\"");
        }
        if (this._variableClass != null) {
            os.print(" variable-class=\"" + this._variableClass + "\"");
        }
        os.print("/>");
    }

    @Override
    public void generatePrologue(JspJavaWriter out) throws Exception {
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        if (this._nameFromAttribute == null) {
            return;
        }
        ArrayList<TldAttribute> attributes = gen.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            TldAttribute attr = attributes.get(i);
            if (!attr.getName().equals(this._nameFromAttribute)) continue;
            if (!String.class.equals((Object)attr.getType())) {
                throw this.error(L.l("name-from-attribute variable '{0}' needs a matching String attribute, not '{1}', because the JSP 2.1 specification requires a String.", (Object)this._nameFromAttribute, (Object)attr.getType().getName()));
            }
            if (!attr.getRequired() && attr.getRequiredVar() != null) {
                throw this.error(L.l("name-from-attribute '{0}' needs an attribute declaration with the required=\"true\" attribute, according to the JSP 2.1 specification.", (Object)this._nameFromAttribute));
            }
            return;
        }
        throw this.error(L.l("name-from-attribute variable '{0}' needs a matching String attribute.", (Object)this._nameFromAttribute));
    }

    @Override
    public void generate(JspJavaWriter out) throws Exception {
    }
}

