/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.HttpJspPage;

public class JspDirectivePage
extends JspNode {
    private static final Logger log = Logger.getLogger(JspDirectivePage.class.getName());
    static L10N L = new L10N(JspDirectivePage.class);
    private static final QName IS_EL_IGNORED = new QName("isELIgnored");
    private static final QName IS_VELOCITY_ENABLED = new QName("isVelocityEnabled");
    private static final QName INFO = new QName("info");
    private static final QName CONTENT_TYPE = new QName("contentType");
    private static final QName PAGE_ENCODING = new QName("pageEncoding");
    private static final QName LANGUAGE = new QName("language");
    private static final QName IMPORT = new QName("import");
    private static final QName SESSION = new QName("session");
    private static final QName BUFFER = new QName("buffer");
    private static final QName ERROR_PAGE = new QName("errorPage");
    private static final QName IS_ERROR_PAGE = new QName("isErrorPage");
    private static final QName AUTO_FLUSH = new QName("autoFlush");
    private static final QName IS_THREAD_SAFE = new QName("isThreadSafe");
    private static final QName EXTENDS = new QName("extends");
    private static final QName TRIM_WS = new QName("trimDirectiveWhitespaces");
    private static final QName DEFER = new QName("deferredSyntaxAllowedAsLiteral");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addAttribute(QName name, String value) throws JspParseException {
        if (IS_EL_IGNORED.equals((Object)name)) {
            boolean isIgnored = value.equals("true");
            if (this._parseState.isELIgnoredPageSpecified() && isIgnored != this._parseState.isELIgnored()) {
                throw this.error(L.l("isELIgnored values conflict"));
            }
            this._parseState.setELIgnored(isIgnored);
            this._parseState.setELIgnoredPageSpecified(true);
            return;
        }
        if (IS_VELOCITY_ENABLED.equals((Object)name)) {
            this._parseState.setVelocityEnabled(value.equals("true"));
            return;
        }
        if (INFO.equals((Object)name)) {
            String oldInfo = this._parseState.getInfo();
            if (oldInfo != null && !value.equals(oldInfo)) {
                throw this.error(L.l("info '{0}' conflicts with previous value of info '{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, (Object)oldInfo));
            }
            this._parseState.setInfo(value);
            return;
        }
        if (CONTENT_TYPE.equals((Object)name)) {
            String oldContentType = this._parseState.getContentType();
            if (oldContentType != null && !value.equals(oldContentType)) {
                throw this.error(L.l("contentType '{0}' conflicts with previous value of contentType '{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, (Object)oldContentType));
            }
            this._parseState.setContentType(value);
            String charEncoding = JspDirectivePage.parseCharEncoding(value);
            if (charEncoding == null) return;
            this._parseState.setCharEncoding(charEncoding);
            return;
        }
        if (PAGE_ENCODING.equals((Object)name)) {
            String oldEncoding = this._parseState.getPageEncoding();
            try {
                this._parseState.setPageEncoding(value);
                return;
            }
            catch (JspParseException e) {
                log.log(Level.FINER, e.toString(), (Throwable)((Object)e));
                throw this.error(e.getMessage());
            }
        }
        if (LANGUAGE.equals((Object)name)) {
            if (value.equals("java")) return;
            throw this.error(L.l("'{0}' is not supported as a JSP scripting language.", (Object)value));
        }
        if (IMPORT.equals((Object)name)) {
            this._parseState.addImport(value);
            return;
        }
        if (SESSION.equals((Object)name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setSession(true);
            } else {
                if (!value.equals("false")) throw this.error(L.l("session expects 'true' or 'false' at '{0}'", (Object)value));
                isValid = this._parseState.setSession(false);
            }
            this._parseState.markSessionSet();
            if (isValid) return;
            throw this.error(L.l("session is assigned different values."));
        }
        if (BUFFER.equals((Object)name)) {
            boolean isValid = this._parseState.setBuffer(this.processBufferSize(value));
            this._parseState.markBufferSet();
            if (!isValid) {
                throw this.error(L.l("buffer is assigned different values."));
            }
            if (this._parseState.getBuffer() != 0 || this._parseState.isAutoFlush()) return;
            throw this.error(L.l("buffer must be non-zero when autoFlush is false."));
        }
        if (ERROR_PAGE.equals((Object)name)) {
            String errorPage = this._parseState.getErrorPage();
            String newErrorPage = this.getRelativeUrl(value);
            this._parseState.setErrorPage(newErrorPage);
            if (errorPage == null || errorPage.equals(newErrorPage)) return;
            this._parseState.setErrorPage(null);
            throw this.error(L.l("errorPage is assigned different value '{0}'.", (Object)newErrorPage));
        }
        if (IS_ERROR_PAGE.equals((Object)name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setErrorPage(true);
            } else {
                if (!value.equals("false")) throw this.error(L.l("isErrorPage expects 'true' or 'false' at '{0}'", (Object)value));
                isValid = this._parseState.setErrorPage(false);
            }
            this._parseState.markErrorPage();
            if (isValid) return;
            throw this.error(L.l("isErrorPage is assigned different values."));
        }
        if (AUTO_FLUSH.equals((Object)name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setAutoFlush(true);
            } else {
                if (!value.equals("false")) throw this.error(L.l("autoFlush expects 'true' or 'false' at '{0}'", (Object)value));
                isValid = this._parseState.setAutoFlush(false);
            }
            if (!isValid) {
                throw this.error(L.l("autoFlush is assigned different values."));
            }
            if (this._parseState.getBuffer() == 0 && !this._parseState.isAutoFlush()) {
                throw this.error(L.l("buffer must be non-zero when autoFlush is false."));
            }
            this._parseState.markAutoFlushSet();
            return;
        }
        if (IS_THREAD_SAFE.equals((Object)name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setThreadSafe(true);
            } else {
                if (!value.equals("false")) throw this.error(L.l("isThreadSafe expects 'true' or 'false' at '{0}'", (Object)value));
                isValid = this._parseState.setThreadSafe(false);
            }
            this._parseState.markThreadSafeSet();
            if (isValid) return;
            throw this.error(L.l("isThreadSafe is assigned different values."));
        }
        if (EXTENDS.equals((Object)name)) {
            Class cl = null;
            try {
                cl = CauchoSystem.loadClass((String)value);
            }
            catch (Exception e) {
                throw this.error(e);
            }
            if (!HttpJspPage.class.isAssignableFrom(cl)) {
                throw this.error(L.l("'{0}' must implement HttpJspPage.  The class named by jsp:directive.page extends='...' must implement HttpJspPage.", (Object)value));
            }
            Class oldExtends = this._parseState.getExtends();
            if (oldExtends != null && !cl.equals(oldExtends)) {
                throw this.error(L.l("extends '{0}' conflicts with previous value of extends '{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, (Object)oldExtends.getName()));
            }
            this._parseState.setExtends(cl);
            return;
        }
        if (TRIM_WS.equals((Object)name)) {
            if (value.equals("true")) {
                this._parseState.setTrimWhitespace(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("trimDirectiveWhitespaces expects 'true' or 'false' at '{0}'", (Object)value));
                this._parseState.setTrimWhitespace(false);
            }
            return;
        } else {
            if (!DEFER.equals((Object)name)) throw this.error(L.l("'{0}' is an unknown JSP page directive attribute.  See the JSP documentation for a complete list of page directive attributes.", (Object)name.getName()));
            if (value.equals("true")) {
                this._parseState.setDeferredSyntaxAllowedAsLiteral(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("deferredSyntaxAllowedAsLiteral expects 'true' or 'false' at '{0}'", (Object)value));
                this._parseState.setDeferredSyntaxAllowedAsLiteral(false);
            }
        }
    }

    private int processBufferSize(String value) throws JspParseException {
        char ch;
        int i;
        if (value.equals("none")) {
            return 0;
        }
        int kb = 0;
        for (i = 0; i < value.length() && (ch = value.charAt(i)) >= '0' && ch <= '9'; ++i) {
            kb = 10 * kb + ch - 48;
        }
        if (!value.substring(i).equals("kb")) {
            throw this.error(L.l("Expected buffer size at '{0}'.  Buffer sizes must end in 'kb'", (Object)value));
        }
        return 1024 * kb;
    }

    protected String getRelativeUrl(String value) {
        if (value.length() > 0 && value.charAt(0) == '/') {
            return value;
        }
        return this._parseState.getUriPwd() + value;
    }

    static String parseCharEncoding(String type) throws JspParseException {
        int i;
        type = type.toLowerCase(Locale.ENGLISH);
        while ((i = type.indexOf(59)) >= 0 && i < type.length()) {
            char ch;
            ++i;
            while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                ++i;
            }
            if (i >= type.length()) {
                return null;
            }
            if ((i = (type = type.substring(i)).indexOf(61)) >= 0) {
                if (!type.startsWith("charset")) continue;
                ++i;
                while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                type = type.substring(i);
            }
            for (i = 0; i < type.length() && (ch = type.charAt(i)) != ';' && ch != ' '; ++i) {
            }
            return type.substring(0, i);
        }
        return null;
    }

    @Override
    public void endAttributes() throws JspParseException {
        if (this._gen.isTag()) {
            throw this.error(L.l("page directives are forbidden in tags."));
        }
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void printXml(WriteStream os) throws IOException {
        ArrayList<String> imports;
        os.print("<jsp:directive.page");
        this.printJspId(os);
        if (!this._parseState.isELIgnored()) {
            os.print(" el-ignored='false'");
        }
        if (this._parseState.getContentType() != null) {
            os.print(" content-type='" + this._parseState.getContentType() + "'");
        }
        if ((imports = this._parseState.getImportList()) != null && imports.size() != 0) {
            os.print(" import='");
            for (int i = 0; i < imports.size(); ++i) {
                if (i != 0) {
                    os.print(',');
                }
                os.print(imports.get(i));
            }
            os.print("'");
        }
        os.print("/>");
    }

    @Override
    public void generate(JspJavaWriter out) throws Exception {
    }
}

