/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.el.AbstractVariableResolver;
import com.caucho.jsp.PageContextImpl;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;

public class PageContextELResolver
extends AbstractVariableResolver {
    private static final Logger log = Logger.getLogger(PageContextELResolver.class.getName());
    private final PageContextImpl _pageContext;
    private final ELResolver[] _customResolvers;
    private final ImplicitObjectELResolver _implicitResolver = new ImplicitObjectELResolver();
    private final ScopedAttributeELResolver _attrResolver = new ScopedAttributeELResolver();
    private final MapELResolver _mapResolver = new MapELResolver();
    private final ListELResolver _listResolver = new ListELResolver();
    private final ArrayELResolver _arrayResolver = new ArrayELResolver();
    private final ResourceBundleELResolver _bundleResolver = new ResourceBundleELResolver();
    private final BeanELResolver _beanResolver = new BeanELResolver();

    public PageContextELResolver(PageContextImpl pageContext, ELResolver[] customResolvers) {
        this._pageContext = pageContext;
        this._customResolvers = customResolvers;
    }

    public ELResolver[] getCustomResolvers() {
        return this._customResolvers;
    }

    public Class<?> getCommonPropertyType(ELContext env, Object base) {
        Class common = null;
        if (base == null) {
            common = String.class;
        }
        for (int i = 0; i < this._customResolvers.length; ++i) {
            common = PageContextELResolver.common(common, this._customResolvers[i].getCommonPropertyType(env, base));
        }
        common = PageContextELResolver.common(common, this._mapResolver.getCommonPropertyType(env, base));
        common = PageContextELResolver.common(common, this._listResolver.getCommonPropertyType(env, base));
        common = PageContextELResolver.common(common, this._arrayResolver.getCommonPropertyType(env, base));
        common = PageContextELResolver.common(common, this._beanResolver.getCommonPropertyType(env, base));
        common = PageContextELResolver.common(common, this._bundleResolver.getCommonPropertyType(env, base));
        return common;
    }

    private static Class common(Class a, Class b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext env, Object base) {
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        for (int i = 0; i < this._customResolvers.length; ++i) {
            this.addDescriptors(descriptors, this._customResolvers[i].getFeatureDescriptors(env, base));
        }
        this.addDescriptors(descriptors, this._mapResolver.getFeatureDescriptors(env, base));
        this.addDescriptors(descriptors, this._beanResolver.getFeatureDescriptors(env, base));
        this.addDescriptors(descriptors, this._bundleResolver.getFeatureDescriptors(env, base));
        this.addDescriptors(descriptors, this._implicitResolver.getFeatureDescriptors(env, base));
        this.addDescriptors(descriptors, this._attrResolver.getFeatureDescriptors(env, base));
        return descriptors.iterator();
    }

    private void addDescriptors(ArrayList<FeatureDescriptor> descriptors, Iterator<FeatureDescriptor> iter) {
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            FeatureDescriptor desc = iter.next();
            descriptors.add(desc);
        }
    }

    public Object getValue(ELContext env, Object base, Object property) {
        try {
            env.setPropertyResolved(false);
            for (int i = 0; i < this._customResolvers.length; ++i) {
                Object value = this._customResolvers[i].getValue(env, base, property);
                if (!env.isPropertyResolved()) continue;
                return value;
            }
            if (base != null) {
                if (base instanceof Map) {
                    return this._mapResolver.getValue(env, base, property);
                }
                if (base instanceof List) {
                    return this._listResolver.getValue(env, base, property);
                }
                if (base.getClass().isArray()) {
                    return this._arrayResolver.getValue(env, base, property);
                }
                if (base instanceof PropertyResourceBundle) {
                    return this._bundleResolver.getValue(env, base, property);
                }
                return this._beanResolver.getValue(env, base, property);
            }
            if (property instanceof String) {
                env.setPropertyResolved(true);
                return this._pageContext.findAttribute(property.toString());
            }
            return null;
        }
        catch (PropertyNotFoundException e) {
            throw e;
        }
        catch (ELException e) {
            if (e.getCause() != null) {
                throw e;
            }
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public Class getType(ELContext env, Object base, Object property) {
        env.setPropertyResolved(false);
        for (int i = 0; i < this._customResolvers.length; ++i) {
            Class value = this._customResolvers[i].getType(env, base, property);
            if (!env.isPropertyResolved()) continue;
            return value;
        }
        if (base != null) {
            if (base instanceof Map) {
                return this._mapResolver.getType(env, base, property);
            }
            if (base instanceof List) {
                return this._listResolver.getType(env, base, property);
            }
            if (base.getClass().isArray()) {
                return this._arrayResolver.getType(env, base, property);
            }
            if (base instanceof PropertyResourceBundle) {
                return this._bundleResolver.getType(env, base, property);
            }
            return this._beanResolver.getType(env, base, property);
        }
        if (base == null && property instanceof String) {
            env.setPropertyResolved(true);
            Object value = this._pageContext.findAttribute(property.toString());
            if (value != null) {
                return value.getClass();
            }
            return null;
        }
        return null;
    }

    public boolean isReadOnly(ELContext env, Object base, Object property) {
        env.setPropertyResolved(false);
        for (int i = 0; i < this._customResolvers.length; ++i) {
            boolean value = this._customResolvers[i].isReadOnly(env, base, property);
            if (!env.isPropertyResolved()) continue;
            return value;
        }
        env.setPropertyResolved(true);
        return false;
    }

    public void setValue(ELContext env, Object base, Object property, Object value) {
        env.setPropertyResolved(false);
        if (base != null) {
            if (base instanceof Map) {
                this._mapResolver.setValue(env, base, property, value);
            } else if (base instanceof List) {
                this._listResolver.setValue(env, base, property, value);
            } else if (base.getClass().isArray()) {
                this._arrayResolver.setValue(env, base, property, value);
            } else {
                this._beanResolver.setValue(env, base, property, value);
            }
        } else if (property instanceof String) {
            for (int i = 0; i < this._customResolvers.length; ++i) {
                this._customResolvers[i].setValue(env, base, property, value);
                if (!env.isPropertyResolved()) continue;
                return;
            }
            env.setPropertyResolved(true);
            this._pageContext.setAttribute(property.toString(), value);
        }
    }
}

