/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jsp.el.ImplicitFieldExpr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class ImplicitObjectExpr
extends Expr {
    static final int PAGE_CONTEXT = 1;
    static final int APPLICATION_SCOPE = 2;
    static final int SESSION_SCOPE = 3;
    static final int REQUEST_SCOPE = 4;
    static final int PAGE_SCOPE = 5;
    static final int PARAM = 6;
    static final int PARAM_VALUES = 7;
    static final int INIT_PARAM = 8;
    static final int HEADER = 9;
    static final int HEADER_VALUES = 10;
    static final int COOKIE = 11;
    private String _id;
    private int _index;

    public ImplicitObjectExpr(String id) {
        this._id = id;
        if ("pageContext".equals(id)) {
            this._index = 1;
        } else if ("applicationScope".equals(id)) {
            this._index = 2;
        } else if ("sessionScope".equals(id)) {
            this._index = 3;
        } else if ("requestScope".equals(id)) {
            this._index = 4;
        } else if ("pageScope".equals(id)) {
            this._index = 5;
        } else if ("param".equals(id)) {
            this._index = 6;
        } else if ("paramValues".equals(id)) {
            this._index = 7;
        } else if ("initParam".equals(id)) {
            this._index = 8;
        } else if ("header".equals(id)) {
            this._index = 9;
        } else if ("headerValues".equals(id)) {
            this._index = 10;
        } else if ("cookie".equals(id)) {
            this._index = 11;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Expr createField(Expr field) {
        switch (this._index) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new ImplicitFieldExpr(this._index, field);
            }
        }
        return super.createField(field);
    }

    public Object getValue(ELContext env) throws ELException {
        if (!(env instanceof PageContextImpl.PageELContext)) {
            return null;
        }
        PageContextImpl page = ((PageContextImpl.PageELContext)env).getPageContext();
        switch (this._index) {
            case 1: {
                return page;
            }
            case 2: {
                return new AttributeMap(page, 4);
            }
            case 3: {
                return new AttributeMap(page, 3);
            }
            case 4: {
                return new AttributeMap(page, 2);
            }
            case 5: {
                return new AttributeMap(page, 1);
            }
            case 7: {
                return page.getRequest().getParameterMap();
            }
            case 6: {
                HashMap<String, String> map = new HashMap<String, String>();
                Map pMap = page.getRequest().getParameterMap();
                for (Map.Entry entry : pMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] value = (String[])entry.getValue();
                    map.put(key, value[0]);
                }
                return map;
            }
            case 8: {
                ServletContext app = page.getServletContext();
                HashMap<String, String> map = new HashMap<String, String>();
                Enumeration e = app.getInitParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    map.put(name, app.getInitParameter(name));
                }
                return map;
            }
            case 9: {
                HttpServletRequest req = page.getRequest();
                HashMap<String, String> map = new HashMap<String, String>();
                Enumeration e = req.getHeaderNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    map.put(name, req.getHeader(name));
                }
                return map;
            }
            case 10: {
                HttpServletRequest req = page.getRequest();
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                Enumeration e = req.getHeaderNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Enumeration values = req.getHeaders(name);
                    ArrayList<String> list = new ArrayList<String>();
                    while (values.hasMoreElements()) {
                        list.add((String)values.nextElement());
                    }
                    map.put(name, list.toArray(new String[list.size()]));
                }
                return map;
            }
            case 11: {
                HashMap<String, Cookie> map = new HashMap<String, Cookie>();
                Cookie[] cookies = page.getRequest().getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    if (map.get(cookies[i].getName()) != null) continue;
                    map.put(cookies[i].getName(), cookies[i]);
                }
                return map;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this._id;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.jsp.el.ImplicitObjectExpr(\"");
        ImplicitObjectExpr.printEscapedString((WriteStream)os, (String)this._id);
        os.print("\")");
    }

    public static class AttributeMap
    extends AbstractMap {
        private PageContext _pageContext;
        private int _scope;
        private EntrySet _entrySet;

        AttributeMap(PageContext pageContext, int scope) {
            this._pageContext = pageContext;
            this._scope = scope;
        }

        @Override
        public Object get(Object key) {
            return this._pageContext.getAttribute((String)key, this._scope);
        }

        @Override
        public Object put(Object key, Object value) {
            this._pageContext.setAttribute((String)key, value, this._scope);
            return null;
        }

        @Override
        public Set entrySet() {
            if (this._entrySet == null) {
                this._entrySet = new EntrySet();
            }
            return this._entrySet;
        }

        public class EntryIterator
        implements Iterator,
        Map.Entry {
            Enumeration _e;
            String _name;
            Object _value;

            EntryIterator() {
                this._e = AttributeMap.this._pageContext.getAttributeNamesInScope(AttributeMap.this._scope);
            }

            @Override
            public boolean hasNext() {
                return this._e.hasMoreElements();
            }

            public Object next() {
                this._name = (String)this._e.nextElement();
                this._value = AttributeMap.this._pageContext.getAttribute(this._name, AttributeMap.this._scope);
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object getKey() {
                return this._name;
            }

            public Object getValue() {
                return this._value;
            }

            public Object setValue(Object value) {
                AttributeMap.this._pageContext.setAttribute(this._name, value, AttributeMap.this._scope);
                Object oldValue = this._value;
                this._value = value;
                return oldValue;
            }

            @Override
            public int hashCode() {
                return this._name.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof EntryIterator)) {
                    return false;
                }
                EntryIterator entry = (EntryIterator)obj;
                return this._name.equals(entry._name) && (this._value == null && entry._value == null || this._value != null && this._value.equals(entry._value));
            }
        }

        public class EntrySet
        extends AbstractSet {
            @Override
            public int size() {
                Enumeration e = AttributeMap.this._pageContext.getAttributeNamesInScope(AttributeMap.this._scope);
                int i = 0;
                while (e.hasMoreElements()) {
                    e.nextElement();
                    ++i;
                }
                return i;
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }
        }
    }
}

