/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class QServlet
implements Servlet {
    static final String COPYRIGHT = "Copyright(c) 1998-2012 Caucho Technology.  All rights reserved.";
    private static final Logger log = Logger.getLogger(QServlet.class.getName());
    private static final L10N L = new L10N(QServlet.class);
    protected WebApp _webApp;
    private PageManager _manager;
    private ServletConfig _config;

    public void init(ServletConfig config) throws ServletException {
        ServletContext cxt = config.getServletContext();
        this._webApp = (WebApp)cxt;
        this._config = config;
        log.finer(config.getServletName() + " init");
    }

    protected void setManager(PageManager manager) {
        this._manager = manager;
    }

    protected PageManager getManager() {
        return this._manager;
    }

    public ServletContext getServletContext() {
        return this._webApp;
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getInitParameter(String name) {
        return this._config.getInitParameter(name);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ResponseAdapter resAdapt;
        block11: {
            CauchoResponse response;
            resAdapt = null;
            CauchoRequest request = req instanceof CauchoRequest ? (CauchoRequest)req : RequestAdapter.create((HttpServletRequest)req, this._webApp);
            if (res instanceof CauchoResponse) {
                response = (CauchoResponse)res;
            } else {
                resAdapt = ResponseAdapter.create((HttpServletResponse)res);
                response = resAdapt;
            }
            Page page = null;
            try {
                page = this.getPage(request, response);
                if (page == null) {
                    response.sendError(404);
                    return;
                }
                page.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (JspParseException e) {
                if (e.getErrorPage() != null) {
                    this.forwardErrorPage(request, response, (Throwable)((Object)e), e.getErrorPage());
                }
                throw new ServletException((Throwable)((Object)e));
            }
            catch (ClientDisconnectException e) {
                throw e;
            }
            catch (Throwable e) {
                if (page != null && page.getErrorPage() != null && this.forwardErrorPage(request, response, e, page.getErrorPage())) break block11;
                if (e instanceof IOException) {
                    log.log(Level.FINE, e.toString(), e);
                    throw (IOException)e;
                }
                if (e instanceof ServletException) {
                    log.log(Level.FINE, e.toString(), e);
                    throw (ServletException)e;
                }
                log.log(Level.FINE, e.toString(), e);
                throw new ServletException(e);
            }
        }
        if (resAdapt != null) {
            resAdapt.close();
            ResponseAdapter.free(resAdapt);
        }
    }

    public Page getPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Page page = this.getSubPage(request, response);
            return page;
        }
        catch (JspParseException e) {
            if (e.getErrorPage() != null) {
                if (e.getCause() != null && !(e instanceof JspLineParseException)) {
                    this.forwardErrorPage(request, response, e.getCause(), e.getErrorPage());
                } else {
                    this.forwardErrorPage(request, response, (Throwable)((Object)e), e.getErrorPage());
                }
                return null;
            }
            throw e;
        }
    }

    private Page getSubPage(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String servletPath;
        CauchoRequest cauchoRequest = null;
        this.initGetPage();
        if (req instanceof CauchoRequest) {
            cauchoRequest = (CauchoRequest)req;
        }
        if ((servletPath = cauchoRequest != null ? cauchoRequest.getPageServletPath() : RequestAdapter.getPageServletPath(req)) == null) {
            servletPath = "/";
        }
        String uri = cauchoRequest != null ? cauchoRequest.getPageURI() : RequestAdapter.getPageURI(req);
        Path appDir = this._webApp.getRootDirectory();
        ServletConfig config = null;
        String jspPath = (String)req.getAttribute("caucho.jsp.jsp-file");
        if (jspPath != null) {
            req.removeAttribute("caucho.jsp.jsp-file");
            Path subcontext = this.getPagePath(jspPath);
            return this._manager.getPage(uri, jspPath, subcontext, config);
        }
        String pathInfo = cauchoRequest != null ? cauchoRequest.getPagePathInfo() : RequestAdapter.getPagePathInfo(req);
        Path subcontext = this.getPagePath(servletPath);
        if (subcontext != null) {
            return this._manager.getPage(servletPath, subcontext);
        }
        if (pathInfo == null) {
            String realPath = this._webApp.getRealPath(servletPath);
            subcontext = appDir.lookupNative(realPath);
            return this._manager.getPage(servletPath, subcontext);
        }
        subcontext = this.getPagePath(servletPath + pathInfo);
        if (subcontext != null) {
            return this._manager.getPage(servletPath + pathInfo, subcontext);
        }
        if (servletPath != null && !servletPath.equals("")) {
            throw new FileNotFoundException(L.l("{0} was not found on this server.", (Object)uri));
        }
        subcontext = this.getPagePath(pathInfo);
        if (subcontext != null) {
            return this._manager.getPage(pathInfo, subcontext);
        }
        subcontext = this.getPagePath(uri);
        if (subcontext == null) {
            throw new FileNotFoundException(L.l("{0} was not found on this server.", (Object)uri));
        }
        return this._manager.getPage(uri, subcontext);
    }

    private void initGetPage() {
        this._webApp.getJspApplicationContext().getELListenerArray();
    }

    public Page getPage(String uri, String pageURI, ServletConfig config) throws Exception {
        Path path = this.getPagePath(pageURI);
        if (path == null) {
            return null;
        }
        return this._manager.getPage(uri, pageURI, path, config);
    }

    private Path getPagePath(String pathName) {
        String name;
        URL url;
        String realPath;
        Path rootDir = this._webApp.getRootDirectory();
        Path path = rootDir.lookupNative(realPath = this._webApp.getRealPath(pathName));
        if (path.isFile() && path.canRead()) {
            return path;
        }
        ClassLoader loader = this._webApp.getClassLoader();
        if (loader != null) {
            url = this._webApp.getClassLoader().getResource(pathName);
            name = url != null ? url.toString() : null;
            path = null;
            if (url != null && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                path = JarPath.create((Path)Vfs.lookup((String)url.toString())).lookup(pathName);
            } else if (url != null) {
                path = Vfs.lookup((String)url.toString());
            }
            if (path != null && path.isFile() && path.canRead()) {
                return path;
            }
        }
        name = (url = ClassLoader.getSystemResource(pathName)) != null ? url.toString() : null;
        path = null;
        if (url != null && (name.endsWith(".jar") || name.endsWith(".zip"))) {
            path = JarPath.create((Path)Vfs.lookup((String)url.toString())).lookup(pathName);
        } else if (url != null) {
            path = Vfs.lookup((String)url.toString());
        }
        if (path != null && path.isFile() && path.canRead()) {
            return path;
        }
        return null;
    }

    public void killPage(HttpServletRequest request, HttpServletResponse response, Page page) {
        this._manager.killPage(request, response, page);
    }

    private boolean forwardErrorPage(HttpServletRequest req, HttpServletResponse res, Throwable e, String errorPage) throws ServletException, IOException {
        RequestDispatcher rd;
        req.setAttribute("javax.servlet.jsp.jspException", (Object)e);
        req.setAttribute("javax.servlet.error.exception_type", (Object)e);
        req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
        if (res instanceof CauchoResponse) {
            CauchoResponse cauchoResponse = (CauchoResponse)res;
            cauchoResponse.killCache();
            cauchoResponse.setNoCache(true);
        }
        if ((rd = req.getRequestDispatcher(errorPage)) == null) {
            return false;
        }
        rd.forward((ServletRequest)req, (ServletResponse)res);
        return true;
    }

    public void destroy() {
        this._manager.destroy();
        log.finer(this._config.getServletName() + " destroy");
    }
}

