/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.LineMap;
import com.caucho.jsp.AppResourceManager;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspServletConfig;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.SingleThreadWrapperPage;
import com.caucho.jsp.TldManager;
import com.caucho.jsp.WrapperPage;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.SingleThreadModel;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspFactory;

public class JspManager
extends PageManager {
    private static final L10N L = new L10N(JspManager.class);
    private static final Logger log = Logger.getLogger(JspManager.class.getName());
    private static int _count;
    private boolean _isXml;
    private boolean _isLoadTldOnInit;
    private boolean _precompile = true;
    private DynamicClassLoader _tagsLoader;

    public JspManager() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
    }

    public boolean getPrecompile() {
        return this._precompile;
    }

    public void setXml(boolean isXml) {
        this._isXml = isXml;
    }

    public void setLoadTldOnInit(boolean isLoadOnInit) {
        this._isLoadTldOnInit = isLoadOnInit;
    }

    public static long getCheckInterval() {
        WebApp webApp = WebApp.getCurrent();
        if (webApp == null) {
            return -1L;
        }
        JspPropertyGroup jsp = webApp.getJsp();
        if (jsp != null) {
            return jsp.getDependencyCheckInterval();
        }
        return -1L;
    }

    public void init() {
        WebApp app = this.getWebApp();
        app.getJspApplicationContext().setPageManager(this);
        if (this._isLoadTldOnInit) {
            try {
                TldManager tld = TldManager.create(new AppResourceManager(app), app);
                tld.init();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    Page createGeneratedPage(Path path, String uri, String className, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        return this.createPage(path, uri, className, config, dependList, true);
    }

    @Override
    Page createPage(Path path, String uri, String className, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        return this.createPage(path, uri, className, config, dependList, false);
    }

    private Page createPage(Path path, String uri, String className, ServletConfig config, ArrayList<PersistentDependency> dependList, boolean isGenerated) throws Exception {
        Page page = this.compile(path, uri, className, config, dependList, isGenerated);
        if (page == null) {
            return null;
        }
        boolean alwaysModified = false;
        if (alwaysModified) {
            page._caucho_setAlwaysModified();
        }
        return page;
    }

    @Override
    protected void initPageManager() {
        JspCompiler compiler = new JspCompiler();
        compiler.setWebApp(this._webApp);
        compiler.setXml(this._isXml);
        try {
            compiler.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Page compile(Path path, String uri, String className, ServletConfig config, ArrayList<PersistentDependency> dependList, boolean isGenerated) throws Exception {
        WebApp webApp = this.getWebApp();
        JspCompiler compiler = new JspCompiler();
        compiler.setJspManager(this);
        compiler.setWebApp(this._webApp);
        compiler.setXml(this._isXml);
        Page page = null;
        try {
            if (this._precompile || this._autoCompile) {
                page = this.preload(className, this.getParentLoader(), webApp.getRootDirectory(), config);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (page != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("loading pre-compiled page for " + uri);
            }
            return page;
        }
        if (path == null || path.isDirectory() || !this._autoCompile) {
            return null;
        }
        Path jspJarPath = null;
        boolean isPathReadable = path.canRead();
        if (!isPathReadable) {
            String resource = "META-INF/resources" + uri;
            this._webApp.getClassLoader().getResource(resource);
            URL url = this._webApp.getClassLoader().getResource(resource);
            if (url != null) {
                jspJarPath = Vfs.lookup((URL)url);
            }
        }
        if (!isPathReadable && jspJarPath == null) {
            return null;
        }
        if (jspJarPath != null) {
            path = jspJarPath;
        }
        JspCompilerInstance compilerInst = compiler.getCompilerInstance(path, uri, className);
        compilerInst.setGeneratedSource(isGenerated);
        compilerInst.addDependList(dependList);
        page = compilerInst.compile();
        Path classPath = this.getClassDir().lookup(className.replace('.', '/') + ".class");
        this.loadPage(page, config, null, uri);
        if (classPath.canRead()) {
            page._caucho_addDepend(classPath.createDepend());
        }
        return page;
    }

    void killPage(CauchoRequest request, CauchoResponse response, Page page) {
    }

    Page preload(String className, ClassLoader parentLoader, Path appDir, ServletConfig config) throws Exception {
        String fullClassName = className;
        String mangledName = fullClassName.replace('.', '/');
        Path classPath = this.getClassDir().lookup(mangledName + ".class");
        DynamicClassLoader loader = SimpleLoader.create((ClassLoader)parentLoader, (Path)this.getClassDir(), null);
        Class<?> cl = null;
        try {
            cl = Class.forName(fullClassName, false, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            log.finest(e.toString());
            return null;
        }
        catch (NoClassDefFoundError e) {
            log.finest(e.toString());
            return null;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            if (this._autoCompile) {
                try {
                    log.warning("removing generated file " + classPath + " due to " + e.toString());
                    classPath.remove();
                }
                catch (IOException e1) {
                    log.log(Level.FINE, e1.toString(), e1);
                }
            }
            return null;
        }
        HttpJspPage jspPage = (HttpJspPage)cl.newInstance();
        Page page = null;
        if (jspPage instanceof CauchoPage) {
            CauchoPage cPage = (CauchoPage)jspPage;
            cPage.init(appDir);
            if (cPage instanceof Page) {
                ((Page)cPage)._caucho_setJspManager(this);
            }
            if (this._autoCompile && cPage._caucho_isModified()) {
                return null;
            }
            page = cPage instanceof Page ? (Page)cPage : new WrapperPage(jspPage);
        } else {
            page = jspPage instanceof SingleThreadModel ? new SingleThreadWrapperPage(jspPage) : new WrapperPage(jspPage);
        }
        page._caucho_addDepend(classPath.createDepend());
        this.loadPage(page, config, null, className);
        return page;
    }

    private Page loadPage(Page page, ServletConfig config, LineMap lineMap, String servletName) throws Exception {
        page.init(this._webApp.getRootDirectory());
        page._caucho_setJspManager(this);
        if (config == null) {
            config = new JspServletConfig(this._webApp, null, servletName);
        }
        page.caucho_init(config);
        return page;
    }

    ClassLoader getParentLoader() {
        return this.getTagsLoader();
    }

    ClassLoader getTagsLoader() {
        DynamicClassLoader tagsLoader = this._tagsLoader;
        if (tagsLoader != null && !tagsLoader.isModifiedNow()) {
            return tagsLoader;
        }
        ClassLoader parentLoader = this.getWebApp().getClassLoader();
        this._tagsLoader = tagsLoader = SimpleLoader.create((ClassLoader)parentLoader, (Path)this.getClassDir(), (String)"_jsp/_web_22dinf/_tags");
        return tagsLoader;
    }

    void unload(Page page) {
    }
}

