/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.JsonArray;
import com.caucho.json.JsonBoolean;
import com.caucho.json.JsonDouble;
import com.caucho.json.JsonInt;
import com.caucho.json.JsonMap;
import com.caucho.json.JsonNull;
import com.caucho.json.JsonNumber;
import com.caucho.json.JsonString;
import com.caucho.json.JsonValue;
import com.caucho.util.Utf8;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class JsonInput2 {
    private ReadStream _is;
    private int _peek = -1;

    public JsonInput2() {
    }

    public JsonInput2(InputStream is) {
        this.init(is);
    }

    public void init(InputStream is) {
        this._is = Vfs.openRead((InputStream)is);
    }

    public JsonValue readObject() throws IOException {
        int ch;
        ReadStream is = this._is;
        if (is == null) {
            return null;
        }
        while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(ch);
                }
                case 34: {
                    return this.parseStringJson();
                }
                case 110: {
                    return this.parseNull((InputStream)is);
                }
                case 116: {
                    return this.parseTrue((InputStream)is);
                }
                case 102: {
                    return this.parseFalse((InputStream)is);
                }
                case 91: {
                    return this.parseArray((InputStream)is);
                }
                case 123: {
                    return this.parseMap((InputStream)is);
                }
            }
        }
        return null;
    }

    public Object readObject(String type) throws IOException {
        return this.readObject();
    }

    public long readLong() throws IOException {
        JsonValue value = this.readObject();
        if (value instanceof Number) {
            return ((Number)((Object)value)).longValue();
        }
        return 0L;
    }

    public double readDouble() throws IOException {
        JsonValue value = this.readObject();
        if (value instanceof Number) {
            return ((Number)((Object)value)).doubleValue();
        }
        return 0.0;
    }

    public String readString() throws IOException {
        JsonValue value = this.readObject();
        return (String)((Object)value);
    }

    public boolean startPacket() throws IOException {
        int ch;
        while ((ch = this.read()) >= 0 && Character.isWhitespace((char)ch)) {
        }
        if (ch < 0) {
            return false;
        }
        if (ch == 0) {
            return true;
        }
        throw new IOException("0x" + Integer.toHexString(ch) + " is an illegal JmtpPacket start");
    }

    public void endPacket() throws IOException {
        int ch;
        while ((ch = this.read()) >= 0 && ch != 255) {
        }
    }

    private JsonNull parseNull(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 117 && (ch = is.read()) == 108 && (ch = is.read()) == 108) {
            return new JsonNull();
        }
        if (ch == -1) {
            throw new IOException(this + " parsing of null failed at <EOF>");
        }
        throw new IOException(this + " parsing of null failed at " + (char)ch);
    }

    private JsonBoolean parseTrue(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 114 && (ch = is.read()) == 117 && (ch = is.read()) == 101) {
            return JsonBoolean.TRUE;
        }
        if (ch == -1) {
            throw new IOException(this + " parsing of true failed at <EOF>");
        }
        throw new IOException(this + " parsing of true failed at " + (char)ch);
    }

    private JsonBoolean parseFalse(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 97 && (ch = is.read()) == 108 && (ch = is.read()) == 115 && (ch = is.read()) == 101) {
            return JsonBoolean.FALSE;
        }
        if (ch == -1) {
            throw new IOException(this + " parsing of false failed at <EOF>");
        }
        throw new IOException(this + " parsing of false failed at " + (char)ch);
    }

    private JsonString parseStringJson() throws IOException {
        return new JsonString(this.parseString());
    }

    private String parseString() throws IOException {
        int ch;
        ReadStream is = this._is;
        StringBuilder sb = new StringBuilder();
        block6: while ((ch = Utf8.read((InputStream)is)) >= 0 && ch != 34) {
            if (ch == 92) {
                ch = Utf8.read((InputStream)is);
                switch (ch) {
                    case 114: {
                        sb.append('\r');
                        continue block6;
                    }
                    case 110: {
                        sb.append('\n');
                        continue block6;
                    }
                    case 116: {
                        sb.append('\t');
                        continue block6;
                    }
                    case 102: {
                        sb.append('\f');
                        continue block6;
                    }
                }
                sb.append((char)ch);
                continue;
            }
            sb.append((char)ch);
        }
        if (ch == -1) {
            throw new IOException(this + " closing '\"' expected at <EOF>");
        }
        return sb.toString();
    }

    private JsonNumber parseNumber(int ch) throws IOException {
        ReadStream is = this._is;
        StringBuilder sb = new StringBuilder();
        boolean isDouble = false;
        block5: while (ch >= 0) {
            switch (ch) {
                case 43: {
                    break;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    sb.append((char)ch);
                    break;
                }
                case 46: 
                case 69: 
                case 101: {
                    sb.append((char)ch);
                    isDouble = true;
                    break;
                }
                default: {
                    this._peek = ch;
                    break block5;
                }
            }
            ch = is.read();
        }
        if (isDouble) {
            return new JsonDouble(Double.parseDouble(sb.toString()));
        }
        return new JsonInt(Long.parseLong(sb.toString()));
    }

    private JsonArray parseArray(InputStream is) throws IOException {
        int ch;
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        block4: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block4;
                }
                case 93: {
                    return new JsonArray(list.toArray(new JsonValue[list.size()]));
                }
            }
            this._peek = ch;
            list.add(this.readObject());
        }
        if (ch == -1) {
            throw new IOException(this + " expected ']' at <EOF>");
        }
        return new JsonArray(list.toArray(new JsonValue[list.size()]));
    }

    private JsonMap parseMap(InputStream is) throws IOException {
        int ch;
        LinkedHashMap<String, JsonValue> map = new LinkedHashMap<String, JsonValue>();
        block5: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block5;
                }
                case 125: {
                    return new JsonMap(map);
                }
                case 34: {
                    String key = this.parseString();
                    ch = this.read();
                    while (ch >= 0 && ch != 58 && ch != 125) {
                        ch = is.read();
                    }
                    if (ch == 58) {
                        JsonValue value = this.readObject();
                        map.put(key, value);
                        continue block5;
                    }
                    return new JsonMap(map);
                }
            }
            this._peek = ch;
            return new JsonMap(map);
        }
        if (ch == -1) {
            throw new IOException(this + " closing '}' expected at <EOF>");
        }
        throw new IOException(this + " closing '}' expected at " + (char)ch);
    }

    private int read() throws IOException {
        int peek = this._peek;
        if (peek >= 0) {
            this._peek = -1;
            return peek;
        }
        return this._is.read();
    }

    public void close() throws IOException {
        ReadStream is = this._is;
        this._is = null;
    }

    public String toString() {
        return JsonInput2.class.getSimpleName() + "[]";
    }
}

