/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.ser.JsonDeserializer;
import com.caucho.json.ser.JsonSerializerFactory;
import com.caucho.util.Utf8;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class JsonInput {
    private InputStream _is;
    private int _peek = -1;
    private JsonSerializerFactory _factory = new JsonSerializerFactory();

    public JsonInput() {
    }

    public JsonInput(InputStream is) {
        this.init(is);
    }

    public void init(InputStream is) {
        this._is = is;
    }

    public Object readObject() throws IOException {
        int ch;
        InputStream is = this._is;
        if (is == null) {
            return null;
        }
        while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(ch);
                }
                case 34: {
                    return this.parseString();
                }
                case 110: {
                    return this.parseNull(is);
                }
                case 116: {
                    return this.parseTrue(is);
                }
                case 102: {
                    return this.parseFalse(is);
                }
                case 91: {
                    return this.parseArray(is);
                }
                case 123: {
                    return this.parseMap(is);
                }
            }
        }
        return null;
    }

    public Object readObject(String type) throws IOException {
        return this.readObject();
    }

    public <T> T readObject(Class<T> type) throws IOException {
        if (type == null || Object.class == type) {
            return (T)this.readObject();
        }
        JsonDeserializer deser = this._factory.getDeserializer(type);
        if (deser == null) {
            return (T)this.readObject();
        }
        return (T)deser.read(this);
    }

    public long readLong() throws IOException {
        Object value = this.readObject();
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    public double readDouble() throws IOException {
        Object value = this.readObject();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public String readString() throws IOException {
        Object value = this.readObject();
        return (String)value;
    }

    public boolean startPacket() throws IOException {
        int ch;
        while ((ch = this.read()) >= 0 && Character.isWhitespace((char)ch)) {
        }
        if (ch < 0) {
            return false;
        }
        if (ch == 0) {
            return true;
        }
        throw new IOException("0x" + Integer.toHexString(ch) + " is an illegal JmtpPacket start");
    }

    public void endPacket() throws IOException {
        int ch;
        while ((ch = this.read()) >= 0 && ch != 255) {
        }
    }

    private Object parseNull(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 117 && (ch = is.read()) == 108 && (ch = is.read()) == 108) {
            return null;
        }
        throw new IOException(this + " parsing of null failed at " + (char)ch);
    }

    private Boolean parseTrue(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 114 && (ch = is.read()) == 117 && (ch = is.read()) == 101) {
            return Boolean.TRUE;
        }
        throw new IOException(this + " parsing of true failed at " + (char)ch);
    }

    private Boolean parseFalse(InputStream is) throws IOException {
        int ch = is.read();
        if (ch == 97 && (ch = is.read()) == 108 && (ch = is.read()) == 115 && (ch = is.read()) == 101) {
            return Boolean.FALSE;
        }
        throw new IOException(this + " parsing of false failed at " + (char)ch);
    }

    private String parseString() throws IOException {
        int ch;
        InputStream is = this._is;
        StringBuilder sb = new StringBuilder();
        block6: while ((ch = Utf8.read((InputStream)is)) >= 0 && ch != 34) {
            if (ch == 92) {
                ch = Utf8.read((InputStream)is);
                switch (ch) {
                    case 114: {
                        sb.append('\r');
                        continue block6;
                    }
                    case 110: {
                        sb.append('\n');
                        continue block6;
                    }
                    case 116: {
                        sb.append('\t');
                        continue block6;
                    }
                    case 102: {
                        sb.append('\f');
                        continue block6;
                    }
                }
                sb.append((char)ch);
                continue;
            }
            sb.append((char)ch);
        }
        if (ch < 0) {
            return null;
        }
        return sb.toString();
    }

    private Number parseNumber(int ch) throws IOException {
        InputStream is = this._is;
        StringBuilder sb = new StringBuilder();
        boolean isDouble = false;
        block5: while (ch >= 0) {
            switch (ch) {
                case 43: {
                    break;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    sb.append((char)ch);
                    break;
                }
                case 46: 
                case 69: 
                case 101: {
                    sb.append((char)ch);
                    isDouble = true;
                    break;
                }
                default: {
                    this._peek = ch;
                    break block5;
                }
            }
            ch = is.read();
        }
        if (isDouble) {
            return Double.parseDouble(sb.toString());
        }
        return Long.parseLong(sb.toString());
    }

    private ArrayList parseArray(InputStream is) throws IOException {
        int ch;
        ArrayList<Object> list = new ArrayList<Object>();
        block4: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block4;
                }
                case 93: {
                    return list;
                }
            }
            this._peek = ch;
            list.add(this.readObject());
        }
        return list;
    }

    private LinkedHashMap parseMap(InputStream is) throws IOException {
        int ch;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        block5: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block5;
                }
                case 125: {
                    return map;
                }
                case 34: {
                    String key = this.parseString();
                    ch = this.read();
                    while (ch >= 0 && ch != 58 && ch != 125) {
                        ch = is.read();
                    }
                    if (ch == 58) {
                        Object value = this.readObject();
                        map.put(key, value);
                        continue block5;
                    }
                    return map;
                }
            }
            this._peek = ch;
            return map;
        }
        return map;
    }

    public void parseBeanMap(Object bean, JsonDeserializer deser) throws IOException {
        int ch;
        InputStream is = this._is;
        block8: while ((ch = this.read()) >= 0 && ch != 123) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block8;
                }
            }
            throw new IOException("'" + (char)ch + "' (0x" + Integer.toHexString(ch) + ") is an unexpected character, expected '{'");
        }
        if (ch < 0) {
            return;
        }
        block9: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block9;
                }
                case 125: {
                    return;
                }
                case 34: {
                    String key = this.parseString();
                    ch = this.read();
                    while (ch >= 0 && ch != 58 && ch != 125) {
                        ch = is.read();
                    }
                    if (ch == 58) {
                        deser.readField(this, bean, key);
                        continue block9;
                    }
                    return;
                }
            }
            this._peek = ch;
            return;
        }
    }

    private int read() throws IOException {
        int peek = this._peek;
        if (peek >= 0) {
            this._peek = -1;
            return peek;
        }
        return this._is.read();
    }

    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
    }
}

