/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.integration;

import com.caucho.config.inject.InjectManager;
import com.caucho.util.L10N;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.ServletContext;

public class Mojarra12InjectionProvider
extends DiscoverableInjectionProvider {
    private static final L10N L = new L10N(InjectManager.class);
    private static final Logger log = Logger.getLogger(InjectManager.class.getName());
    protected ServletContext _context;
    protected BeanManager _manager;
    private Map<Class<?>, AnnotatedType<?>> _types = new HashMap();
    private Map<AnnotatedType<?>, InjectionTarget<?>> _targets = new HashMap();

    public Mojarra12InjectionProvider(ServletContext context) {
        this._context = context;
        this._manager = InjectManager.getCurrent();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("Created Mojarra12InjectionProvider using InjectManager {0} for context {1}", (Object)this._manager, (Object)this._context));
        }
    }

    public void inject(Object o) throws InjectionProviderException {
        Class<?> cl = o.getClass();
        InjectionTarget<?> target = this.getInjectionTarget(cl);
        if (log.isLoggable(Level.FINEST)) {
            log.fine(L.l("{0} injecting bean '{1}'", (Object)this, o));
        }
        target.inject(o, this._manager.createCreationalContext(null));
    }

    public void invokePreDestroy(Object o) throws InjectionProviderException {
        Class<?> cl = o.getClass();
        InjectionTarget<?> target = this.getInjectionTarget(cl);
        if (log.isLoggable(Level.FINEST)) {
            log.fine(L.l("{0} PreDestroy bean '{1}'", (Object)this, o));
        }
        target.preDestroy(o);
    }

    public void invokePostConstruct(Object o) throws InjectionProviderException {
        Class<?> cl = o.getClass();
        InjectionTarget<?> target = this.getInjectionTarget(cl);
        if (log.isLoggable(Level.FINEST)) {
            log.fine(L.l("{0} PostConstruct bean '{1}'", (Object)this, o));
        }
        target.postConstruct(o);
    }

    public String toString() {
        return Mojarra12InjectionProvider.class.getSimpleName() + "[" + this._context + "]";
    }

    private <X> InjectionTarget<X> getInjectionTarget(Class<X> cl) {
        InjectionTarget target;
        AnnotatedType type = this._types.get(cl);
        if (type == null) {
            type = this._manager.createAnnotatedType(cl);
            this._types.put(cl, type);
        }
        if ((target = this._targets.get(type)) == null) {
            target = this._manager.createInjectionTarget(type);
            this._targets.put(type, target);
        }
        return target;
    }
}

