/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import com.caucho.util.CharBuffer;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;

public class LikeSelector
extends Selector {
    private Selector _expr;
    private String _likeString;
    private Pattern _pattern;

    LikeSelector(Selector expr, String likeString, char escape) throws JMSException {
        this._expr = expr;
        this._likeString = likeString;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        block8: for (int i = 0; i < likeString.length(); ++i) {
            char ch = likeString.charAt(i);
            if (ch == escape && i + 1 < likeString.length()) {
                ch = likeString.charAt(i + 1);
                switch (ch) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        cb.append('\\');
                        cb.append(ch);
                        break;
                    }
                    default: {
                        cb.append(ch);
                    }
                }
                ++i;
                continue;
            }
            switch (ch) {
                case '_': {
                    cb.append(".");
                    continue block8;
                }
                case '%': {
                    cb.append(".*");
                    continue block8;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    cb.append('\\');
                    cb.append(ch);
                    continue block8;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        cb.append("$");
        this._pattern = Pattern.compile(cb.toString());
    }

    @Override
    boolean isBoolean() {
        return true;
    }

    @Override
    boolean isUnknown() {
        return false;
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Object value = this._expr.evaluate(message);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return Boolean.FALSE;
        }
        String s = (String)value;
        return this._pattern.matcher(s).find() ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return this._expr + " LIKE " + this._likeString;
    }
}

