/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.config.types.Period;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import java.util.logging.Logger;

public abstract class PollingTopic<E>
extends AbstractTopic<E>
implements AlarmListener {
    private static final L10N L = new L10N(PollingTopic.class);
    private static final Logger log = Logger.getLogger(PollingTopic.class.getName());
    private long _pollPeriod = 10000L;
    private boolean _isPolling;
    private WeakAlarm _alarm = new WeakAlarm((AlarmListener)this);

    protected PollingTopic() {
    }

    public void setPollPeriod(Period period) {
        this._pollPeriod = period.getPeriod();
    }

    protected boolean isPolling() {
        return this._isPolling;
    }

    public void startPoll() {
        this._isPolling = true;
        this._alarm.queue(this._pollPeriod);
    }

    public void stopPoll() {
        this._isPolling = false;
        this._alarm.dequeue();
    }

    public void handleAlarm(Alarm alarm) {
        try {
            this.run();
        }
        finally {
            if (this._isPolling) {
                this._alarm.queue(this._pollPeriod);
            }
        }
    }

    protected void run() {
    }
}

