/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.jca.ra.ResourceDeploy;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ResourceDeployMXBean;
import com.caucho.vfs.Path;

public class ResourceDeployAdmin
extends AbstractManagedObject
implements ResourceDeployMXBean {
    private final ResourceDeploy _resourceDeploy;

    public ResourceDeployAdmin(ResourceDeploy resourceDeploy) {
        this._resourceDeploy = resourceDeploy;
    }

    protected ResourceDeploy getResourceDeploy() {
        return this._resourceDeploy;
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.registerSelf();
    }

    public String getName() {
        Path containerRootDirectory = this.getResourceDeploy().getContainerRootDirectory();
        Path archiveDirectory = this.getResourceDeploy().getArchiveDirectory();
        if (containerRootDirectory == null) {
            return archiveDirectory.getNativePath();
        }
        return containerRootDirectory.lookupRelativeNativePath(archiveDirectory);
    }

    @Override
    public long getDependencyCheckInterval() {
        return this.getResourceDeploy().getDependencyCheckInterval();
    }

    @Override
    public String getArchiveDirectory() {
        return this.getResourceDeploy().getArchiveDirectory().getNativePath();
    }

    @Override
    public String getArchivePath(String name) {
        return this.getResourceDeploy().getArchivePath(name).getNativePath();
    }

    @Override
    public String getExtension() {
        return this.getResourceDeploy().getExtension();
    }

    @Override
    public String getExpandDirectory() {
        return this.getResourceDeploy().getExpandDirectory().getNativePath();
    }

    @Override
    public String getExpandPrefix() {
        return this.getResourceDeploy().getExpandPrefix();
    }

    @Override
    public String getExpandSuffix() {
        return this.getResourceDeploy().getExpandSuffix();
    }

    @Override
    public String getExpandPath(String name) {
        Path path = this.getResourceDeploy().getExpandPath(name);
        return path == null ? null : path.getNativePath();
    }

    @Override
    public String getRedeployMode() {
        return this.getResourceDeploy().getRedeployMode().toString();
    }

    @Override
    public String getStartupMode() {
        return this.getResourceDeploy().getStartupMode().toString();
    }

    @Override
    public boolean isModified() {
        return this.getResourceDeploy().isModified();
    }

    @Override
    public String getState() {
        return this.getResourceDeploy().getState();
    }

    @Override
    public void start() {
        this.getResourceDeploy().start();
    }

    @Override
    public Throwable getConfigException() {
        return this.getResourceDeploy().getConfigException();
    }

    @Override
    public void stop() {
        this.getResourceDeploy().stop();
    }

    @Override
    public void update() {
        this.getResourceDeploy().update();
    }

    @Override
    public String[] getNames() {
        return this.getResourceDeploy().getNames();
    }

    @Override
    public void deploy(String name) {
        this.getResourceDeploy().start(name);
    }

    @Override
    public void start(String name) {
        this.getResourceDeploy().start(name);
    }

    @Override
    public Throwable getConfigException(String moduleID) {
        return this.getResourceDeploy().getConfigException(moduleID);
    }

    @Override
    public void stop(String name) {
        this.getResourceDeploy().stop(name);
    }

    @Override
    public void undeploy(String name) {
        this.getResourceDeploy().undeploy(name);
    }
}

