/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.jca.cfg.ConnectorConfig;
import com.caucho.jca.cfg.ResourceAdapterConfig;
import com.caucho.jca.ra.ResourceManagerImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.resource.spi.ResourceAdapter;

public class ResourceManagerConfig {
    private static final L10N L = new L10N(ResourceManagerConfig.class);
    private Path _configDirectory;
    private ArrayList<ConnectorConfig> _connList = new ArrayList();

    public ResourceManagerConfig() throws ConfigException {
        ResourceManagerImpl.createLocalManager();
    }

    public void setConfigDirectory(Path path) {
        this._configDirectory = path;
    }

    public ConnectorConfig getConnector(String adapterClass) {
        for (int i = 0; i < this._connList.size(); ++i) {
            ConnectorConfig conn = this._connList.get(i);
            ResourceAdapterConfig ra = conn.getResourceAdapter();
            if (ra.getResourceadapterClass() == null || !adapterClass.equals(ra.getResourceadapterClass().getName())) continue;
            return conn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws ConfigException {
        if (this._configDirectory == null) {
            throw new ConfigException(L.l("resource-manager requires a config-directory"));
        }
        try {
            Path path = this._configDirectory;
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                if (!name.endsWith(".ra")) continue;
                ReadStream is = path.lookup(name).openRead();
                try {
                    ConnectorConfig conn = new ConnectorConfig();
                    new Config().configure((Object)conn, (InputStream)is, "com/caucho/jca/jca.rnc");
                    this._connList.add(conn);
                    continue;
                }
                finally {
                    is.close();
                }
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        for (int i = 0; i < this._connList.size(); ++i) {
            ConnectorConfig conn = this._connList.get(i);
            this.initResource(conn);
        }
    }

    private void initResource(ConnectorConfig conn) throws ConfigException {
        ResourceAdapterConfig raCfg = conn.getResourceAdapter();
        try {
            Class<?> raClass = raCfg.getResourceadapterClass();
            ResourceAdapter ra = (ResourceAdapter)raClass.newInstance();
            Method init = raClass.getMethod("init", new Class[0]);
            if (init != null) {
                init.invoke((Object)ra, (Object[])null);
            }
            ResourceManagerImpl.addResource(ra);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

