/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import com.caucho.hemp.broker.DomainManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempDomainManager
extends DomainManager {
    private static final Logger log = Logger.getLogger(HempDomainManager.class.getName());
    private final HashMap<String, WeakReference<Mailbox>> _domainMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomain(String name, Mailbox domain) {
        HashMap<String, WeakReference<Mailbox>> hashMap = this._domainMap;
        synchronized (hashMap) {
            this._domainMap.put(name, new WeakReference<Mailbox>(domain));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " add " + domain + " as '" + name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageStream removeDomain(String name) {
        WeakReference<Mailbox> domainRef = null;
        HashMap<String, WeakReference<Mailbox>> hashMap = this._domainMap;
        synchronized (hashMap) {
            domainRef = this._domainMap.remove(name);
        }
        if (domainRef != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " remove " + name);
            }
            return (MessageStream)domainRef.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mailbox findDomain(String name) {
        WeakReference<Mailbox> domainRef = null;
        HashMap<String, WeakReference<Mailbox>> hashMap = this._domainMap;
        synchronized (hashMap) {
            domainRef = this._domainMap.get(name);
        }
        if (domainRef != null) {
            return (Mailbox)domainRef.get();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

