/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.vfs;

import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.env.vfs.RepositoryRoot;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;

public class RepositoryPath
extends Path {
    private static final L10N L = new L10N(RepositoryPath.class);
    private RepositoryRoot _repository;
    private RepositoryPath _root;
    private Path _physicalPath;

    public RepositoryPath(String tagId, Path physicalRoot) throws IOException {
        super((Path)null);
        RepositorySystem repositorySystem = RepositorySystem.getCurrent();
        if (repositorySystem == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)RepositorySystem.class.getName()));
        }
        physicalRoot.mkdirs();
        RepositorySpi repositorySpi = repositorySystem.getRepositorySpi();
        this._repository = new RepositoryRoot(tagId, repositorySpi, physicalRoot);
        this._physicalPath = physicalRoot;
        this._root = this;
    }

    protected RepositoryPath(RepositoryRoot repository, RepositoryPath root, Path physicalPath) {
        super((Path)root);
        this._repository = repository;
        this._root = root;
        this._physicalPath = physicalPath;
    }

    public String getPath() {
        return this._physicalPath.getPath();
    }

    public String getScheme() {
        return "cloud";
    }

    public Path schemeWalk(String userPath, Map<String, Object> newAttributes, String newPath, int offset) {
        Path physicalPath = this._physicalPath.schemeWalk(userPath, newAttributes, newPath, offset);
        return new RepositoryPath(this._repository, this._root, physicalPath);
    }

    public boolean exists() {
        this.update();
        return this._physicalPath.exists();
    }

    public boolean isFile() {
        this.update();
        return this._physicalPath.isFile();
    }

    public boolean isDirectory() {
        this.update();
        return this._physicalPath.isDirectory();
    }

    public boolean canRead() {
        this.update();
        return this._physicalPath.canRead();
    }

    public boolean canWrite() {
        return false;
    }

    public long getLength() {
        this.update();
        return this._physicalPath.getLength();
    }

    public long getLastModified() {
        this.update();
        return this._physicalPath.getLastModified();
    }

    public long getCreateTime() {
        this.update();
        return this._physicalPath.getCreateTime();
    }

    public long getLastAccessTime() {
        this.update();
        return this._physicalPath.getLastAccessTime();
    }

    public long getCrc64() {
        return this._physicalPath.getCrc64();
    }

    public String[] list() throws IOException {
        this.update();
        String[] list = this._physicalPath.list();
        this._physicalPath.clearStatusCache();
        return list;
    }

    public StreamImpl openReadImpl() throws IOException {
        this.update();
        return this._physicalPath.openReadImpl();
    }

    public Path unwrap() {
        return this._physicalPath.unwrap();
    }

    private void update() {
        this._repository.update();
    }
}

