/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.FileRepository;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;

public class RepositorySystem
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 50;
    private static final L10N L = new L10N(RepositorySystem.class);
    private AbstractRepository _repository;

    public RepositorySystem(AbstractRepository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this._repository = repository;
    }

    public static RepositorySystem createAndAddService() {
        return RepositorySystem.createAndAddService(new FileRepository());
    }

    public static RepositorySystem createAndAddService(AbstractRepository repository) {
        ResinSystem system = RepositorySystem.preCreate(RepositorySystem.class);
        RepositorySystem service = new RepositorySystem(repository);
        system.addService(RepositorySystem.class, (ResinSubSystem)service);
        return service;
    }

    public static RepositorySystem getCurrent() {
        return (RepositorySystem)ResinSystem.getCurrentService(RepositorySystem.class);
    }

    public static Repository getCurrentRepository() {
        RepositorySystem service = RepositorySystem.getCurrent();
        if (service == null) {
            throw new IllegalStateException(L.l("RepositoryService is not available in this context"));
        }
        return service.getRepository();
    }

    public static RepositorySpi getCurrentRepositorySpi() {
        RepositorySystem service = RepositorySystem.getCurrent();
        if (service == null) {
            throw new IllegalStateException(L.l("RepositoryService is not available in this context"));
        }
        return service.getRepositorySpi();
    }

    public Repository getRepository() {
        return this._repository;
    }

    public RepositorySpi getRepositorySpi() {
        return this._repository;
    }

    public int getStartPriority() {
        return 50;
    }

    public void start() {
        this._repository.start();
    }

    public void stop() {
        this._repository.stop();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this._repository + "]";
    }
}

