/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jpa;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.config.inject.HandleAware;
import com.caucho.env.jpa.PersistenceUnitManager;
import com.caucho.transaction.ManagedResource;
import com.caucho.transaction.ManagedXAResource;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class EntityManagerJtaProxy
implements EntityManager,
Serializable,
HandleAware {
    private static final L10N L = new L10N(EntityManagerJtaProxy.class);
    private static final Logger log = Logger.getLogger(EntityManagerJtaProxy.class.getName());
    private final PersistenceUnitManager _persistenceUnit;
    private EntityManagerFactory _emf;
    private final UserTransactionProxy _ut;
    private final FreeList<EntityManager> _idleEntityManagerPool = new FreeList(8);
    private Object _serializationHandle;

    public EntityManagerJtaProxy(PersistenceUnitManager pUnit) {
        this._persistenceUnit = pUnit;
        this._ut = UserTransactionProxy.getCurrent();
        if (this._persistenceUnit == null) {
            throw new NullPointerException();
        }
        if (this._ut == null) {
            throw new NullPointerException();
        }
    }

    void init() {
    }

    public EntityManagerFactory getEntityManagerFactory() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getEntityManagerFactory();
        }
        em = this.createEntityManager();
        try {
            EntityManagerFactory entityManagerFactory = em.getEntityManagerFactory();
            return entityManagerFactory;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public Map<String, Object> getProperties() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getProperties();
        }
        em = this.createEntityManager();
        try {
            Map map = em.getProperties();
            return map;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.setProperty(propertyName, value);
            return;
        }
        em = this.createEntityManager();
        try {
            em.setProperty(propertyName, value);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public void joinTransaction() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not use joinTransaction."));
    }

    public Object getDelegate() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em;
        }
        em = this.createEntityManager();
        try {
            EntityManager entityManager = em;
            return entityManager;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public void setExtended(boolean isExtended) {
        throw new IllegalStateException(L.l("Container-managed @PersistenceContext may not be converted to extended"));
    }

    public Metamodel getMetamodel() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getMetamodel();
        }
        em = this.createEntityManager();
        try {
            Metamodel metamodel = em.getMetamodel();
            return metamodel;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getCriteriaBuilder();
        }
        em = this.createEntityManager();
        try {
            CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            Object value = em.find(entityClass, primaryKey);
            return (T)value;
        }
        em = this.createEntityManager();
        try {
            Object value;
            Object object = value = em.find(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.find(entityClass, primaryKey, properties);
        }
        em = this.createEntityManager();
        try {
            Object object = em.find(entityClass, primaryKey, properties);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.find(entityClass, primaryKey, lockMode);
        }
        em = this.createEntityManager();
        try {
            Object object = em.find(entityClass, primaryKey, lockMode);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.find(entityClass, primaryKey, lockMode, properties);
        }
        em = this.createEntityManager();
        try {
            Object object = em.find(entityClass, primaryKey, lockMode, properties);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.getReference(entityClass, primaryKey);
        }
        em = this.createEntityManager();
        try {
            Object object = em.getReference(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.persist(entity);
            return;
        }
        try {
            if (this._ut.getStatus() == 6) {
                throw new TransactionRequiredException(L.l("persist must be called within transaction."));
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        em = this.createEntityManager();
        try {
            em.persist(entity);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.merge(entity);
        }
        em = this.createEntityManager();
        try {
            Object object = em.merge(entity);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.remove(entity);
            return;
        }
        try {
            if (this._ut.getStatus() == 6) {
                throw new TransactionRequiredException(L.l("remove must be called within transaction."));
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        em = this.createEntityManager();
        try {
            em.remove(entity);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.refresh(entity);
            return;
        }
        try {
            if (this._ut.getStatus() == 6) {
                throw new TransactionRequiredException(L.l("refresh must be called within transaction."));
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        em = this.createEntityManager();
        try {
            em.refresh(entity);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.refresh(entity, properties);
            return;
        }
        em = this.createEntityManager();
        try {
            em.refresh(entity, properties);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.refresh(entity, lockMode);
            return;
        }
        em = this.createEntityManager();
        try {
            em.refresh(entity, lockMode);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.refresh(entity, lockMode, properties);
            return;
        }
        em = this.createEntityManager();
        try {
            em.refresh(entity, lockMode, properties);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public void detach(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.detach(entity);
            return;
        }
        em = this.createEntityManager();
        try {
            em.detach(entity);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.contains(entity);
        }
        em = this.createEntityManager();
        try {
            boolean bl = em.contains(entity);
            return bl;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public FlushModeType getFlushMode() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getFlushMode();
        }
        em = this.createEntityManager();
        try {
            FlushModeType flushModeType = em.getFlushMode();
            return flushModeType;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public void setFlushMode(FlushModeType mode) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.setFlushMode(mode);
            return;
        }
        em = this.createEntityManager();
        try {
            em.setFlushMode(mode);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public void flush() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.flush();
            return;
        }
        em = this.createEntityManager();
        try {
            em.flush();
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.getLockMode(entity);
        }
        em = this.createEntityManager();
        try {
            LockModeType lockModeType = em.getLockMode(entity);
            return lockModeType;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.lock(entity, lockMode);
            return;
        }
        em = this.createEntityManager();
        try {
            em.lock(entity, lockMode);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.lock(entity, lockMode, properties);
            return;
        }
        em = this.createEntityManager();
        try {
            em.lock(entity, lockMode, properties);
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String sql) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createQuery(sql);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createQuery(sql);
            return query;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String sql) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createNamedQuery(sql);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createNamedQuery(sql);
            return query;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sql) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createNativeQuery(sql);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createNativeQuery(sql);
            return query;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sql, String map) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createNativeQuery(sql, map);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createNativeQuery(sql, map);
            return query;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sql, Class retType) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createNativeQuery(sql, retType);
        }
        em = this.createEntityManager();
        try {
            Query query = em.createNativeQuery(sql, retType);
            return query;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createNamedQuery(name, resultClass);
        }
        em = this.createEntityManager();
        try {
            TypedQuery typedQuery = em.createNamedQuery(name, resultClass);
            return typedQuery;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createQuery(criteriaQuery);
        }
        em = this.createEntityManager();
        try {
            TypedQuery typedQuery = em.createQuery(criteriaQuery);
            return typedQuery;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String query, Class<T> resultClass) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return em.createQuery(query, resultClass);
        }
        em = this.createEntityManager();
        try {
            TypedQuery typedQuery = em.createQuery(query, resultClass);
            return typedQuery;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> cls) {
        EntityManager em = this.getCurrent();
        if (em != null) {
            return (T)em.unwrap(cls);
        }
        em = this.createEntityManager();
        try {
            Object object = em.unwrap(cls);
            return (T)object;
        }
        finally {
            this.freeEntityManager(em);
        }
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not use getTransaction."));
    }

    public boolean isOpen() {
        return true;
    }

    public void clear() {
        EntityManager em = this.getCurrent();
        if (em != null) {
            em.clear();
        }
    }

    public void close() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not be closed."));
    }

    void closeImpl() {
        EntityManager em = null;
        while ((em = (EntityManager)this._idleEntityManagerPool.allocate()) != null) {
            em.close();
        }
    }

    private EntityManager getCurrent() {
        try {
            TransactionImpl xa = (TransactionImpl)this._ut.getTransaction();
            if (xa == null) {
                return null;
            }
            EntityManagerItem item = (EntityManagerItem)xa.getAttribute("resin.env.jpa.EntityManagerItem");
            if (item != null) {
                return item.getEntityManager();
            }
            if (this._emf == null) {
                this._emf = this._persistenceUnit.getEntityManagerFactoryDelegate();
                if (this._emf == null) {
                    throw new IllegalStateException(L.l("{0}: EntityManagerFactory cannot be found from {1}", (Object)this, (Object)this._persistenceUnit));
                }
            }
            if (xa != null && xa.getStatus() == 0) {
                EntityManager em = this._emf.createEntityManager((Map)this._persistenceUnit.getProperties());
                item = new EntityManagerItem(item, em, (Transaction)xa);
                xa.setAttribute("resin.env.jpa.EntityManagerItem", (Object)item);
                xa.registerSynchronization((Synchronization)item);
                return em;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    private EntityManager createEntityManager() {
        EntityManager em = (EntityManager)this._idleEntityManagerPool.allocate();
        if (em == null) {
            if (this._emf == null) {
                this._emf = this._persistenceUnit.getEntityManagerFactoryDelegate();
            }
            if (this._emf == null) {
                throw new IllegalStateException(L.l("{0} does not have a valid delegate.", (Object)this._persistenceUnit));
            }
            em = this._emf.createEntityManager((Map)this._persistenceUnit.getProperties());
        }
        return em;
    }

    private void freeEntityManager(EntityManager em) {
        em.clear();
        if (!em.isOpen() || !this._idleEntityManagerPool.free((Object)em)) {
            em.close();
        }
    }

    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._persistenceUnit + "]";
    }

    class EntityManagerItem
    implements Synchronization,
    ManagedResource {
        private final EntityManagerItem _prev;
        private final EntityManager _em;
        private final Transaction _xa;

        EntityManagerItem(EntityManagerItem prev, EntityManager em, Transaction xa) {
            this._prev = prev;
            this._em = em;
            this._xa = xa;
        }

        EntityManager getEntityManager() {
            return this._em;
        }

        Transaction getXa() {
            return this._xa;
        }

        EntityManagerItem getPrev() {
            return this._prev;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.close();
        }

        public void close() {
            EntityManagerJtaProxy.this.freeEntityManager(this._em);
        }

        public void abortConnection() {
            this.close();
        }

        public IllegalStateException getAllocationStackTrace() {
            return null;
        }

        public Object getUserConnection() {
            return EntityManagerJtaProxy.this;
        }

        public ManagedXAResource getXAResource() {
            return null;
        }

        public boolean isCloseDanglingConnections() {
            return false;
        }

        public void setSaveAllocationStackTrace(boolean isEnable) {
        }
    }
}

