/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jpa;

import com.caucho.config.Names;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.jpa.PersistenceUnitManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

public class EntityManagerFactoryProxy
implements EntityManagerFactory,
Serializable {
    private final transient PersistenceUnitManager _persistenceUnit;
    private transient EntityManagerFactory _emfDelegate;

    public EntityManagerFactoryProxy(PersistenceUnitManager persistenceUnit) {
        this._persistenceUnit = persistenceUnit;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public void close() {
    }

    void closeImpl() {
        this._emfDelegate = null;
    }

    public boolean isOpen() {
        return this._persistenceUnit.isOpen();
    }

    public Map getProperties() {
        return this.getDelegate().getProperties();
    }

    public Cache getCache() {
        return this.getDelegate().getCache();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getDelegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getDelegate().getMetamodel();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getDelegate().getPersistenceUnitUtil();
    }

    private EntityManagerFactory getDelegate() {
        if (this._emfDelegate == null) {
            this._emfDelegate = this._persistenceUnit.getEntityManagerFactoryDelegate();
        }
        return this._emfDelegate;
    }

    private Object writeReplace() {
        return new Handle(this._persistenceUnit.getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._persistenceUnit.getName() + "," + this._emfDelegate + "]";
    }

    public static class Handle
    implements Serializable {
        private String _name;

        private Handle() {
        }

        private Handle(String name) {
            this._name = name;
        }

        private Object readResolve() {
            InjectManager beanManager = InjectManager.getCurrent();
            return beanManager.getReference(EntityManagerFactory.class, new Annotation[]{Names.create((String)this._name)});
        }
    }
}

