/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jpa;

import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.naming.Jndi;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

public class ConfigPersistenceUnit {
    private String _name;
    private String _version;
    private String _description;
    private Class<?> _provider;
    private String _jtaDataSourceName;
    private String _nonJtaDataSourceName;
    private DataSource _jtaDataSource;
    private DataSource _nonJtaDataSource;
    private boolean _isExcludeUnlistedClasses;
    private URL _rootUrl;
    private DynamicClassLoader _loader;
    private ContainerProgram _program = new ContainerProgram();
    private PersistenceUnitTransactionType _transactionType = PersistenceUnitTransactionType.JTA;
    private Properties _properties = new Properties();
    private HashMap<String, Class<?>> _classMap = new HashMap();
    private ArrayList<String> _mappingFiles = new ArrayList();
    private ArrayList<String> _jarFiles = new ArrayList();
    private ArrayList<URL> _jarFileUrls = new ArrayList();

    public ConfigPersistenceUnit(URL rootUrl) {
        this._rootUrl = rootUrl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this._transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this._transactionType = transactionType;
    }

    public URL getRoot() {
        return this._rootUrl;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public Class<?> getProvider() {
        return this._provider;
    }

    public DataSource getJtaDataSource() {
        if (this._jtaDataSourceName == null) {
            return null;
        }
        if (this._jtaDataSource == null) {
            this._jtaDataSource = this.loadDataSource(this._jtaDataSourceName);
        }
        return this._jtaDataSource;
    }

    public String getJtaDataSourceName() {
        return this._jtaDataSourceName;
    }

    public DataSource getNonJtaDataSource() {
        if (this._nonJtaDataSourceName == null) {
            return null;
        }
        if (this._nonJtaDataSource == null) {
            this._nonJtaDataSource = this.loadDataSource(this._nonJtaDataSourceName);
        }
        return this._nonJtaDataSource;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    ContainerProgram getProgram() {
        return this._program;
    }

    @PostConstruct
    public void init() {
    }

    protected DataSource loadDataSource(String name) {
        DataSource ds = (DataSource)Jndi.lookup((String)name);
        if (ds != null) {
            return ds;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

