/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.util.Hex;
import com.caucho.util.IoUtil;
import com.caucho.util.Utf8;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;

public class GitObjectStream
extends InputStream {
    private static final HashMap<String, GitType> _gitTypeMap = new HashMap();
    private InputStream _rawStream;
    private InflaterInputStream _is;
    private GitType _type;
    private long _length;

    public GitObjectStream(Path path) throws IOException {
        this((InputStream)path.openRead());
    }

    public GitObjectStream(InputStream rawStream) throws IOException {
        int ch;
        this._rawStream = rawStream;
        this._is = new InflaterInputStream(this._rawStream);
        StringBuilder type = new StringBuilder();
        while ((ch = this._is.read()) >= 0 && ch != 32) {
            type.append((char)ch);
        }
        this._type = _gitTypeMap.get(type.toString());
        long length = 0L;
        while ((ch = this._is.read()) >= 0 && 48 <= ch && ch <= 57) {
            length = length * 10L + (long)ch - 48L;
        }
        this._length = length;
        while (ch > 0) {
            ch = this._is.read();
        }
    }

    public GitType getType() {
        return this._type;
    }

    public long getLength() {
        return this._length;
    }

    public GitCommit parseCommit() throws IOException {
        int ch;
        GitCommit commit = new GitCommit();
        while ((ch = this._is.read()) >= 0) {
            StringBuilder keyBuilder = new StringBuilder();
            while (ch >= 0 && ch != 32 && ch != 10) {
                keyBuilder.append((char)ch);
                ch = this._is.read();
            }
            String key = keyBuilder.toString();
            if (key.length() == 0) {
                StringBuilder msg = new StringBuilder();
                ch = this._is.read();
                while (ch >= 0) {
                    msg.append((char)ch);
                    commit.setMessage(msg.toString());
                    ch = this._is.read();
                }
                break;
            }
            while (ch == 32) {
                ch = this._is.read();
            }
            StringBuilder value = new StringBuilder();
            while (ch >= 0 && ch != 10) {
                if (ch != 13) {
                    value.append((char)ch);
                }
                ch = this._is.read();
            }
            if ("tree".equals(key)) {
                commit.setTree(value.toString());
            }
            if ("parent".equals(key)) {
                commit.setParent(value.toString());
                continue;
            }
            commit.put(key, value.toString());
        }
        return commit;
    }

    public GitTree parseTree() throws IOException {
        int ch;
        GitTree tree = new GitTree();
        while ((ch = this._is.read()) >= 0) {
            int mode = 0;
            while (48 <= ch && ch <= 55) {
                mode = mode * 8 + ch - 48;
                ch = this._is.read();
            }
            while (ch == 32) {
                ch = this._is.read();
            }
            StringBuilder nameBuffer = new StringBuilder();
            while (ch > 0) {
                nameBuffer.append((char)Utf8.read((InputStream)this._is, (int)ch));
                ch = this._is.read();
            }
            String name = nameBuffer.toString();
            byte[] sha1 = new byte[20];
            for (int i = 0; i < sha1.length; ++i) {
                sha1[i] = (byte)this._is.read();
            }
            tree.addEntry(name, mode, Hex.toHex((byte[])sha1));
        }
        return tree;
    }

    public InputStream getInputStream() {
        return this;
    }

    @Override
    public int read() throws IOException {
        return this._is.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this._is.read(buffer, offset, length);
    }

    @Override
    public void close() {
        InputStream in = this._rawStream;
        this._rawStream = null;
        IoUtil.close((InputStream)in);
        InflaterInputStream is = this._is;
        this._is = null;
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this._type) + ",length=" + this._length + "]";
    }

    static {
        _gitTypeMap.put("blob", GitType.BLOB);
        _gitTypeMap.put("tree", GitType.TREE);
        _gitTypeMap.put("commit", GitType.COMMIT);
    }
}

