/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.DeployActionHandler;
import com.caucho.env.deploy.DeployNotificationListener;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.ConcurrentArrayList;

public class DeployTagItem {
    private final String _tag;
    private final Lifecycle _lifecycle = new Lifecycle();
    private final ConcurrentArrayList<DeployNotificationListener> _listeners = new ConcurrentArrayList(DeployNotificationListener.class);
    private final ConcurrentArrayList<DeployActionHandler> _actionHandlers = new ConcurrentArrayList(DeployActionHandler.class);
    private Throwable _deployException;

    public DeployTagItem(String tag) {
        this._tag = tag;
    }

    public String getTag() {
        return this._tag;
    }

    public void toStart() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._deployException = null;
        for (DeployActionHandler handler : (DeployActionHandler[])this._actionHandlers.toArray()) {
            handler.toStart();
        }
    }

    public void toStop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        for (DeployActionHandler handler : (DeployActionHandler[])this._actionHandlers.toArray()) {
            handler.toStop();
        }
    }

    public void toRestart() {
        this._lifecycle.toStop();
        if (!this._lifecycle.toActive()) {
            return;
        }
        for (DeployActionHandler handler : this._actionHandlers) {
            handler.toRestart();
        }
    }

    public void onStart() {
        this._lifecycle.toActive();
        this._deployException = null;
        for (DeployNotificationListener listener : (DeployNotificationListener[])this._listeners.toArray()) {
            listener.onStart();
        }
    }

    public void onStop() {
        this._lifecycle.toStop();
        this._deployException = null;
        for (DeployNotificationListener listener : (DeployNotificationListener[])this._listeners.toArray()) {
            listener.onStop();
        }
    }

    public LifecycleState getState() {
        return this._lifecycle.getState();
    }

    public String getStateName() {
        return this._lifecycle.getStateName();
    }

    public void toError(Throwable exn) {
        this._lifecycle.toError();
        this._deployException = exn;
    }

    public Throwable getDeployException() {
        return this._deployException;
    }

    public void addNotificationListener(DeployNotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._listeners.add((Object)listener);
    }

    public void removeNotificationListener(DeployNotificationListener listener) {
        this._listeners.remove((Object)listener);
    }

    public void addActionHandler(DeployActionHandler handler) {
        this._actionHandlers.add((Object)handler);
    }

    public void removeActionHandler(DeployActionHandler handler) {
        this._actionHandlers.remove((Object)handler);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tag + "]";
    }
}

