/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.dbpool;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.env.dbpool.IdlePoolSet;
import com.caucho.env.dbpool.ManagedPoolItem;
import com.caucho.env.dbpool.UserPoolItem;
import com.caucho.env.health.HealthStatus;
import com.caucho.env.health.HealthStatusService;
import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.inject.Module;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ConnectionPoolMXBean;
import com.caucho.transaction.ManagedXAResource;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

@Module
public class ConnectionPool
extends AbstractManagedObject
implements ConnectionManager,
AlarmListener,
ConnectionPoolMXBean {
    private static final L10N L = new L10N(ConnectionPool.class);
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());
    private final AtomicInteger _idGen = new AtomicInteger();
    private String _name;
    private UserTransactionProxy _tm;
    private int _maxConnections = 1024;
    private int _maxOverflowConnections = 1024;
    private int _maxCreateConnections = 5;
    private int _maxIdleCount = 1024;
    private int _minIdleCount = 0;
    private long _idleTimeout = 60000L;
    private long _activeTimeout = 21600000L;
    private long _poolTimeout = 86400000L;
    private long _connectionWaitTimeout = 30000L;
    private boolean _isEnableLocalTransaction = true;
    private boolean _isEnableXA = true;
    private boolean _isLocalTransactionOptimization = true;
    private boolean _isShareable = true;
    private boolean _isSaveAllocationStackTrace = false;
    private boolean _isCloseDanglingConnections = true;
    private ManagedConnectionFactory _mcf;
    private final ArrayList<ManagedPoolItem> _connectionPool = new ArrayList();
    private IdlePoolSet _idlePool;
    private final ArrayList<ManagedPoolItem> _alarmConnections = new ArrayList();
    private Alarm _alarm;
    private long _lastValidCheckTime;
    private long _idlePoolExpire;
    private final AtomicInteger _idCount = new AtomicInteger();
    private final Object _availableLock = new Object();
    private final AtomicInteger _availableWaitCount = new AtomicInteger();
    private final AtomicInteger _createCount = new AtomicInteger();
    private ActiveTimeMeter _connectionTime;
    private ActiveTimeMeter _idleTime;
    private ActiveTimeMeter _queryTime;
    private final AtomicLong _connectionCountTotal = new AtomicLong();
    private final AtomicLong _connectionCreateCountTotal = new AtomicLong();
    private final AtomicLong _connectionFailCountTotal = new AtomicLong();
    private long _lastFailTime;
    private final Lifecycle _lifecycle = new Lifecycle();

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setTransactionManager(UserTransactionProxy tm) {
        this._tm = tm;
    }

    public UserTransactionProxy getTransactionManager() {
        return this._tm;
    }

    public boolean isShareable() {
        return this._isShareable;
    }

    public void setShareable(boolean isShareable) {
        this._isShareable = isShareable;
    }

    public boolean isLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization;
    }

    public void setLocalTransactionOptimization(boolean enable) {
        this._isLocalTransactionOptimization = enable;
    }

    public boolean allowLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization && this._isShareable;
    }

    public boolean getSaveAllocationStackTrace() {
        return this._isSaveAllocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean save) {
        this._isSaveAllocationStackTrace = save;
    }

    public boolean isCloseDanglingConnections() {
        return this._isCloseDanglingConnections;
    }

    public void setCloseDanglingConnections(boolean isClose) {
        this._isCloseDanglingConnections = isClose;
    }

    public void setLocalTransaction(boolean localTransaction) {
        this._isEnableLocalTransaction = localTransaction;
    }

    public boolean isLocalTransaction() {
        return this._isEnableLocalTransaction;
    }

    public void setXATransaction(boolean enable) {
        this._isEnableXA = enable;
    }

    public boolean isXATransaction() {
        return this._isEnableXA;
    }

    public long getMaxIdleTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._idleTimeout) {
            return -1L;
        }
        return this._idleTimeout;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._idleTimeout = maxIdleTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxIdleTime;
    }

    public int getMaxIdleCount() {
        return this._maxIdleCount;
    }

    public void setMaxIdleCount(int maxIdleCount) {
        this._maxIdleCount = maxIdleCount < 0 ? 0 : maxIdleCount;
    }

    public int getMinIdleCount() {
        return this._minIdleCount;
    }

    public void setMinIdleCount(int minIdleCount) {
        this._minIdleCount = minIdleCount < 0 ? 0 : minIdleCount;
    }

    public long getMaxActiveTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._activeTimeout) {
            return -1L;
        }
        return this._activeTimeout;
    }

    public void setMaxActiveTime(long maxActiveTime) {
        this._activeTimeout = maxActiveTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxActiveTime;
    }

    public long getMaxPoolTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._poolTimeout) {
            return -1L;
        }
        return this._poolTimeout;
    }

    public void setMaxPoolTime(long maxPoolTime) {
        this._poolTimeout = maxPoolTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxPoolTime;
    }

    public void setMaxConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-connections '0' must be at least 1."));
        }
        this._maxConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxConnections() {
        if (this._maxConnections < 0x3FFFFFFF) {
            return this._maxConnections;
        }
        return -1;
    }

    public void setConnectionWaitTime(Period waitTime) {
        this._connectionWaitTimeout = waitTime.getPeriod();
        if (this._connectionWaitTimeout < 0L) {
            this._connectionWaitTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public long getConnectionWaitTime() {
        if (this._connectionWaitTimeout < 0x3FFFFFFFFFFFFFFFL) {
            return this._connectionWaitTimeout;
        }
        return -1L;
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._maxOverflowConnections = maxOverflowConnections;
    }

    public int getMaxOverflowConnections() {
        return this._maxOverflowConnections;
    }

    public void setMaxCreateConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-create-connections '0' must be at least 1."));
        }
        this._maxCreateConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxCreateConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxCreateConnections() {
        if (this._maxCreateConnections < 0x3FFFFFFF) {
            return this._maxCreateConnections;
        }
        return -1;
    }

    public ActiveTimeMeter getConnectionTimeProbe() {
        return this._connectionTime;
    }

    public ActiveTimeMeter getIdleTimeProbe() {
        return this._idleTime;
    }

    public ActiveTimeMeter getActiveTimeProbe() {
        return this._queryTime;
    }

    public int getConnectionCount() {
        return this._connectionPool.size();
    }

    public int getConnectionIdleCount() {
        return this._idlePool.size();
    }

    public int getConnectionCreateCount() {
        return this._createCount.get();
    }

    public int getConnectionActiveCount() {
        return this._connectionPool.size() - this._idlePool.size();
    }

    public long getConnectionCountTotal() {
        return this._connectionCountTotal.get();
    }

    public long getConnectionCreateCountTotal() {
        return this._connectionCreateCountTotal.get();
    }

    public long getConnectionFailCountTotal() {
        return this._connectionFailCountTotal.get();
    }

    public Date getLastFailTime() {
        return new Date(this._lastFailTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object init(ManagedConnectionFactory mcf) throws ConfigException, ResourceException {
        if (!this._lifecycle.toInit()) {
            return null;
        }
        this._mcf = mcf;
        if (this._name == null) {
            int v = this._idGen.incrementAndGet();
            this._name = mcf.getClass().getSimpleName() + "-" + v;
        }
        if (this._tm == null) {
            throw new ConfigException(L.l("the connection manager needs a transaction manager."));
        }
        this._idlePool = new IdlePoolSet(this._maxIdleCount);
        this._connectionTime = MeterService.createActiveTimeMeter((String)"Resin|Database|Connection");
        this._idleTime = MeterService.createActiveTimeMeter((String)"Resin|Database|Idle");
        this._queryTime = MeterService.createActiveTimeMeter((String)"Resin|Database|Query");
        this.registerSelf();
        this._alarm = new WeakAlarm((AlarmListener)this);
        if (!(mcf instanceof ValidatingManagedConnectionFactory)) {
            this._lastValidCheckTime = 0x3FFFFFFFFFFFFFFFL;
        }
        if (this._isEnableXA) {
            Subject subject = null;
            ManagedConnection mConn = mcf.createManagedConnection(subject, null);
            try {
                XAResource xa = mConn.getXAResource();
                this._tm.recover(xa);
            }
            catch (NotSupportedException e) {
                log.finer(e.toString());
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
            finally {
                mConn.destroy();
            }
        }
        return mcf.createConnectionFactory((ConnectionManager)this);
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (0L < this._idleTimeout && this._idleTimeout < 1000L) {
            this._alarm.queue(1000L);
        } else if (1000L < this._idleTimeout && this._idleTimeout < 60000L) {
            this._alarm.queue(this._idleTimeout);
        } else {
            this._alarm.queue(60000L);
        }
    }

    String generateId() {
        return String.valueOf(this._idCount.getAndIncrement());
    }

    UserTransactionImpl getTransaction() {
        return this._tm.getUserTransaction();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo info) throws ResourceException {
        Subject subject = null;
        Object conn = this.allocateConnection(mcf, subject, info);
        this._connectionCountTotal.incrementAndGet();
        return conn;
    }

    private Object allocateConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        UserPoolItem userPoolItem = null;
        try {
            while (true) {
                Object userConn;
                userPoolItem = null;
                UserTransactionImpl transaction = this._tm.getUserTransaction();
                if (transaction != null) {
                    userPoolItem = this.allocateShared(transaction, mcf, subject, info);
                }
                if (userPoolItem == null) {
                    userPoolItem = this.allocatePoolConnection(mcf, subject, info, null);
                }
                if ((userConn = userPoolItem.allocateUserConnection()) != null) {
                    userPoolItem = null;
                    Object object = userConn;
                    return object;
                }
                userPoolItem.close();
            }
        }
        finally {
            if (userPoolItem != null) {
                userPoolItem.close();
            }
        }
    }

    private UserPoolItem allocateShared(UserTransactionImpl transaction, ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (!transaction.isActive()) {
            return null;
        }
        ArrayList poolItems = transaction.getXaResources();
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            ManagedPoolItem poolItem;
            UserPoolItem item;
            ManagedXAResource xaResource = (ManagedXAResource)poolItems.get(i);
            if (!(xaResource instanceof ManagedPoolItem) || (item = (poolItem = (ManagedPoolItem)xaResource).allocateXA(mcf, subject, info)) == null) continue;
            return item;
        }
        return null;
    }

    ManagedPoolItem findJoin(UserTransactionImpl uTrans, ManagedPoolItem item) {
        if (!uTrans.isActive()) {
            return null;
        }
        ArrayList poolItems = uTrans.getXaResources();
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            ManagedPoolItem poolItem;
            ManagedXAResource resource = (ManagedXAResource)poolItems.get(i);
            if (!(resource instanceof ManagedPoolItem) || !(poolItem = (ManagedPoolItem)resource).isJoin(item)) continue;
            return poolItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserPoolItem allocatePoolConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        long expireTime = CurrentTime.getCurrentTimeActual() + this._connectionWaitTimeout;
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0}: Can't allocate connection because the connection pool is closed.", (Object)this));
        }
        do {
            UserPoolItem userPoolItem;
            if ((userPoolItem = this.allocateIdleConnection(mcf, subject, info, oldPoolItem)) != null) {
                return userPoolItem;
            }
            if (!this.startCreateConnection()) continue;
            try {
                UserPoolItem userPoolItem2 = this.createConnection(mcf, subject, info, oldPoolItem);
                return userPoolItem2;
            }
            finally {
                this.finishCreateConnection();
            }
        } while (this._lifecycle.isActive() && this.waitForAvailableConnection(expireTime));
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0}: Can't allocate connection because the connection pool is closed.", (Object)this));
        }
        String message = (Object)((Object)this) + " pool throttled create timeout (pool-size=" + this._connectionPool.size() + ", max-connections=" + this._maxConnections + ", create-count=" + this._createCount.get() + ", max-create-connections=" + this._maxCreateConnections + ")";
        HealthStatusService.updateCurrentHealthStatus((Object)((Object)this), (HealthStatus)HealthStatus.WARNING, (String)message);
        if (this.startCreateOverflow()) {
            try {
                UserPoolItem userPoolItem = this.createConnection(mcf, subject, info, oldPoolItem);
                return userPoolItem;
            }
            finally {
                this.finishCreateConnection();
            }
        }
        message = (Object)((Object)this) + " pool overflow failed to create (pool-size=" + this._connectionPool.size() + ", max-connections=" + this._maxConnections + ", create-count=" + this._createCount.get() + ", max-create-connections=" + this._maxCreateConnections + ")";
        HealthStatusService.updateCurrentHealthStatus((Object)((Object)this), (HealthStatus)HealthStatus.CRITICAL, (String)message);
        throw new ResourceException(L.l("Can't create overflow connection connection-max={0}", (long)this._maxConnections));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem allocateIdleConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        while (this._lifecycle.isActive()) {
            ManagedConnection mConn;
            long now = CurrentTime.getCurrentTime();
            if (this._lastValidCheckTime + 15000L < now) {
                this._lastValidCheckTime = now;
                if (mcf instanceof ValidatingManagedConnectionFactory) {
                    ValidatingManagedConnectionFactory vmcf = (ValidatingManagedConnectionFactory)mcf;
                    this.validate(vmcf);
                }
            }
            ManagedPoolItem poolItem = null;
            do {
                ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
                synchronized (arrayList) {
                    mConn = mcf.matchManagedConnections((Set)this._idlePool, subject, info);
                    if (mConn == null) {
                        return null;
                    }
                    if (!this._idlePool.remove(mConn)) {
                        mConn = null;
                    }
                }
            } while (mConn == null);
            poolItem = this.findPoolItem(mConn);
            if (poolItem == null) {
                throw new IllegalStateException(L.l("Unexpected non-matching PoolItem found for {0}", (Object)mConn));
            }
            try {
                UserPoolItem userPoolItem = poolItem.toActive(subject, info, oldPoolItem);
                if (userPoolItem == null) continue;
                poolItem = null;
                UserPoolItem userPoolItem2 = userPoolItem;
                return userPoolItem2;
            }
            finally {
                if (poolItem == null) continue;
                poolItem.destroy();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedPoolItem findPoolItem(ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            for (int i = this._connectionPool.size() - 1; i >= 0; --i) {
                ManagedPoolItem testPoolItem = this._connectionPool.get(i);
                if (testPoolItem.getManagedConnection() != mConn) continue;
                return testPoolItem;
            }
            return null;
        }
    }

    private void validate(ValidatingManagedConnectionFactory mcf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem createConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        boolean isValid = false;
        ManagedPoolItem poolItem = null;
        try {
            ManagedConnection mConn = mcf.createManagedConnection(subject, info);
            if (mConn == null) {
                throw new ResourceException(L.l("'{0}' did not return a connection from createManagedConnection", (Object)mcf));
            }
            poolItem = new ManagedPoolItem(this, mcf, mConn);
            UserPoolItem userPoolItem = poolItem.toActive(subject, info, oldPoolItem);
            if (userPoolItem == null) {
                throw new ResourceException(L.l("Connection '{0}' was not valid on creation", (Object)poolItem));
            }
            this._connectionCreateCountTotal.incrementAndGet();
            Object object = this._connectionPool;
            synchronized (object) {
                this._connectionPool.add(poolItem);
            }
            poolItem = null;
            isValid = true;
            object = userPoolItem;
            return object;
        }
        finally {
            if (!isValid) {
                this._connectionFailCountTotal.incrementAndGet();
                this._lastFailTime = CurrentTime.getCurrentTime();
            }
            if (poolItem != null) {
                poolItem.destroy();
            }
        }
    }

    private boolean startCreateConnection() throws ResourceException {
        if (this.isCreateAvailable()) {
            this._createCount.incrementAndGet();
            return true;
        }
        return false;
    }

    private void finishCreateConnection() {
        this._createCount.decrementAndGet();
        this.notifyConnectionAvailable();
    }

    private boolean startCreateOverflow() throws ResourceException {
        int size = this._connectionPool.size();
        int createCount = this._createCount.incrementAndGet();
        if (createCount + size <= this._maxConnections + this._maxOverflowConnections) {
            return true;
        }
        this._createCount.decrementAndGet();
        String message = L.l("{0} cannot create overflow connection after {1}ms (pool-size={2}, max-connections={3}, create-count={4}, max-create-connections={5}, max-overflow-connections={6})", new Object[]{this, this._connectionWaitTimeout, this._connectionPool.size(), this._maxConnections, this._createCount.get(), this._maxCreateConnections, this._maxOverflowConnections});
        HealthStatusService.updateCurrentHealthStatus((Object)((Object)this), (HealthStatus)HealthStatus.WARNING, (String)message);
        throw new ResourceException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForAvailableConnection(long expireTime) {
        boolean bl;
        boolean isAfterWait;
        this._availableWaitCount.incrementAndGet();
        try {
            Object object = this._availableLock;
            synchronized (object) {
                isAfterWait = false;
            }
        }
        catch (Throwable throwable) {
            this._availableWaitCount.decrementAndGet();
            throw throwable;
        }
        {
            while (!this.isIdleAvailable() && !this.isCreateAvailable()) {
                long delta;
                block10: {
                    long now = CurrentTime.getCurrentTimeActual();
                    delta = expireTime - now;
                    if (delta > 0L) break block10;
                    boolean bl2 = isAfterWait;
                    // MONITOREXIT @DISABLED, blocks:[2, 6, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var3_2
                    this._availableWaitCount.decrementAndGet();
                    return bl2;
                }
                try {
                    Thread.interrupted();
                    this._availableLock.wait(delta);
                    isAfterWait = true;
                }
                catch (InterruptedException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            bl = true;
        }
        this._availableWaitCount.decrementAndGet();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionAvailable() {
        if (this._availableWaitCount.get() > 0) {
            Object object = this._availableLock;
            synchronized (object) {
                this._availableLock.notifyAll();
            }
        }
    }

    private boolean isIdleAvailable() {
        return this._idlePool.size() > 0;
    }

    private boolean isCreateAvailable() {
        return this._connectionPool.size() < this._maxConnections && this._createCount.get() < this._maxCreateConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForPoolRemoval(ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            for (int i = this._connectionPool.size() - 1; i >= 0; --i) {
                ManagedPoolItem poolItem = this._connectionPool.get(i);
                if (poolItem.getManagedConnection() != mConn) continue;
                poolItem.setConnectionError();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toIdle(ManagedPoolItem item) {
        try {
            ManagedConnection mConn = item.getManagedConnection();
            if (mConn == null) {
                return;
            }
            if (item.isConnectionError()) {
                this.removeItem(item, mConn);
                return;
            }
            if (this._maxConnections < this._connectionPool.size()) {
                return;
            }
            mConn.cleanup();
            long now = CurrentTime.getCurrentTime();
            if (this._idlePool.size() == 0) {
                this._idlePoolExpire = now + this._idleTimeout;
            }
            ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
            synchronized (arrayList) {
                block19: {
                    if (this._idlePoolExpire < now) {
                        this._idlePoolExpire = now + this._idleTimeout;
                        break block19;
                    }
                    if (!this._idlePool.add(mConn)) break block19;
                    item = null;
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            this.notifyConnectionAvailable();
            if (item != null) {
                item.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(ManagedPoolItem item, ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            this._idlePool.remove(mConn);
            this._connectionPool.remove(item);
            this._connectionPool.notifyAll();
        }
        try {
            item.destroy();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<ManagedPoolItem> pool = this._connectionPool;
        if (pool == null) {
            return;
        }
        ArrayList<ManagedPoolItem> clearItems = new ArrayList<ManagedPoolItem>();
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            this._idlePool.clear();
            clearItems.addAll(pool);
            pool.clear();
        }
        for (int i = 0; i < clearItems.size(); ++i) {
            ManagedPoolItem poolItem = (ManagedPoolItem)clearItems.get(i);
            try {
                poolItem.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            this._alarmConnections.clear();
            ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
            synchronized (arrayList) {
                this._alarmConnections.addAll(this._connectionPool);
            }
            for (int i = this._alarmConnections.size() - 1; i >= 0; --i) {
                ManagedPoolItem item = this._alarmConnections.get(i);
                if (item.isValid()) continue;
                item.destroy();
            }
            this._alarmConnections.clear();
            this.fillIdlePool();
        }
        finally {
            if (this._lifecycle.isActive()) {
                if (0L < this._idleTimeout && this._idleTimeout < 1000L) {
                    this._alarm.queue(1000L);
                } else if (1000L < this._idleTimeout && this._idleTimeout < 60000L) {
                    this._alarm.queue(this._idleTimeout);
                } else {
                    this._alarm.queue(60000L);
                }
            }
        }
    }

    private void fillIdlePool() {
        int count = this._minIdleCount;
        try {
            while (this._connectionPool.size() < this._minIdleCount && count-- >= 0 && this._lifecycle.isActive()) {
                Subject subject = null;
                ConnectionRequestInfo info = null;
                UserPoolItem userPoolItem = this.createConnection(this._mcf, subject, info, null);
                if (userPoolItem == null) continue;
                userPoolItem.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        log.finer((Object)((Object)this) + " stopping");
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<ManagedPoolItem> pool;
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            pool = new ArrayList<ManagedPoolItem>(this._connectionPool);
            this._connectionPool.clear();
            if (this._idlePool != null) {
                this._idlePool.clear();
            }
        }
        for (int i = 0; i < pool.size(); ++i) {
            ManagedPoolItem poolItem = pool.get(i);
            try {
                poolItem.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.getName() + "]";
    }
}

