/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessManager;
import com.caucho.ejb.session.StatelessProxyFactory;
import com.caucho.inject.Module;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.SessionBean;
import javax.enterprise.inject.spi.Interceptor;

@Module
public class StatelessPool<X, T> {
    private static final Logger log = Logger.getLogger(StatelessPool.class.getName());
    private static final L10N L = new L10N(StatelessPool.class);
    private final StatelessManager<X> _manager;
    private final StatelessContext<X, T> _context;
    private final List<Interceptor<?>> _interceptorBeans;
    private final FreeList<Item<X>> _freeList;
    private final ThreadLocal<Item<X>> _lifecycleInstanceLocal = new ThreadLocal();
    private final StatelessProxyFactory _proxy;
    private final Semaphore _concurrentSemaphore;
    private final long _concurrentTimeout;

    StatelessPool(StatelessManager<X> manager, StatelessProxyFactory proxy, StatelessContext<X, T> context, List<Interceptor<?>> interceptorBeans) {
        this._manager = manager;
        this._proxy = proxy;
        this._context = context;
        this._interceptorBeans = interceptorBeans;
        int idleMax = manager.getSessionIdleMax();
        int concurrentMax = manager.getSessionConcurrentMax();
        if (idleMax < 0) {
            idleMax = concurrentMax;
        }
        if (idleMax < 0) {
            idleMax = 16;
        }
        this._freeList = new FreeList(idleMax);
        if (concurrentMax == 0) {
            throw new IllegalArgumentException(L.l("maxConcurrent may not be zero"));
        }
        long concurrentTimeout = manager.getSessionConcurrentTimeout();
        if (concurrentTimeout < 0L) {
            concurrentTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
        this._concurrentTimeout = concurrentTimeout;
        this._concurrentSemaphore = concurrentMax > 0 ? new Semaphore(concurrentMax) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item<X> allocate() {
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            try {
                Thread.interrupted();
                if (!semaphore.tryAcquire(this._concurrentTimeout, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException(L.l("{0} concurrent max exceeded", (Object)this));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean isValid = false;
        try {
            Item beanItem = (Item)this._freeList.allocate();
            if (beanItem == null) {
                OwnerCreationalContext env = new OwnerCreationalContext(this._manager.getBean());
                Object instance = this._context.newInstance((CreationalContextImpl<X>)env);
                Object[] bindings = this._manager.getInterceptorBindings(this._interceptorBeans, (CreationalContextImpl<?>)env);
                if (instance instanceof SessionBean) {
                    try {
                        ((SessionBean)instance).setSessionContext(this._context);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
                Object[] delegates = this._manager.createDelegates((CreationalContextImpl<?>)env);
                beanItem = new Item(instance, bindings, delegates);
                Item<X> oldInstance = this._lifecycleInstanceLocal.get();
                try {
                    this._lifecycleInstanceLocal.set(beanItem);
                    this._proxy.__caucho_postConstruct();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this._lifecycleInstanceLocal.set(oldInstance);
                }
            }
            isValid = true;
            this._manager.setLocalStatelessPool(this);
            Item item = beanItem;
            return item;
        }
        finally {
            if (!isValid && semaphore != null) {
                semaphore.release();
            }
        }
    }

    public X getLifecycleInstance() {
        Item<X> item = this._lifecycleInstanceLocal.get();
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public Item<X> getLifecycleItem() {
        return this._lifecycleInstanceLocal.get();
    }

    public void free(Item<X> beanItem) {
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
        this._manager.setLocalStatelessPool(null);
        if (!this._freeList.free(beanItem)) {
            this.destroyImpl(beanItem);
        }
    }

    public void destroy(Item<X> beanItem) {
        if (beanItem == null) {
            return;
        }
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
        this._manager.setLocalStatelessPool(null);
        this.destroyImpl(beanItem);
    }

    public void discard(Item<X> beanItem) {
        if (beanItem == null) {
            return;
        }
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
    }

    public Class<?> getLocalApi() {
        return this._context.getApi();
    }

    private void destroyImpl(Item<X> beanItem) {
        this._manager.destroyInstance(beanItem.getValue());
    }

    public void destroy() {
        Item beanItem;
        while ((beanItem = (Item)this._freeList.allocate()) != null) {
            this.destroyImpl(beanItem);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._manager + "]";
    }

    public static class Item<X> {
        private X _value;
        private Object[] _interceptorObjects;
        private Object[] _delegates;

        Item(X value, Object[] interceptorObjects, Object[] delegates) {
            this._value = value;
            this._interceptorObjects = interceptorObjects;
            this._delegates = delegates;
        }

        public X getValue() {
            return this._value;
        }

        public Object[] _caucho_getInterceptorObjects() {
            return this._interceptorObjects;
        }

        public Object[] __caucho_getDelegates() {
            return this._delegates;
        }
    }
}

