/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.StatefulManager;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import javax.ejb.TimerService;

@Module
public class StatefulContext<X, T>
extends AbstractSessionContext<X, T> {
    private static final L10N L = new L10N(StatefulContext.class);
    private ThreadLocal<T> _businessLocal = new ThreadLocal();

    public StatefulContext(StatefulManager<X> manager, Class<T> api) {
        super(manager, api);
    }

    @Override
    public StatefulManager<X> getServer() {
        return (StatefulManager)super.getServer();
    }

    @Override
    public T createProxy(CreationalContextImpl<T> env) {
        T proxy = super.createProxy(env);
        ((StatefulManager)this.getServer()).initProxy(proxy, env);
        return proxy;
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        throw new IllegalStateException(L.l("Stateful session beans cannot call SessionContext.getTimerService()"));
    }

    public T startLocal(T local) {
        T oldLocal = this._businessLocal.get();
        this._businessLocal.set(local);
        return oldLocal;
    }

    public void endLocal(T oldLocal) {
        this._businessLocal.set(oldLocal);
    }

    @Override
    protected T getLocal() {
        return this._businessLocal.get();
    }
}

