/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.services.name.NameServerRemote;
import com.caucho.util.L10N;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class HessianModel
extends AbstractModel {
    private static final Logger log = Logger.getLogger(HessianModel.class.getName());
    private static L10N L = new L10N(HessianModel.class);
    private String _urlPrefix;
    private String _namePrefix;
    private HessianModel _root;
    private Hashtable _cache;
    private NameServerRemote _remoteRoot;
    private NameServerRemote _remote;

    public HessianModel(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this._urlPrefix = prefix;
        this._namePrefix = "/";
        this._root = this;
        this._cache = new Hashtable();
    }

    public HessianModel(String namePrefix, HessianModel root) {
        if (!namePrefix.endsWith("/")) {
            namePrefix = namePrefix + '/';
        }
        this._namePrefix = namePrefix;
        this._root = root;
    }

    void setRemote(NameServerRemote remote) {
        this._remote = remote;
    }

    public AbstractModel copy() {
        return this;
    }

    String getURLPrefix() {
        return this._root._urlPrefix;
    }

    public Object lookup(String name) throws NamingException {
        try {
            String urlPrefix = this.getURLPrefix();
            String cacheName = urlPrefix + this._namePrefix + name;
            Object obj = this._root._cache.get(cacheName);
            if (obj != null) {
                return obj;
            }
            return obj;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper((Throwable)e);
        }
    }

    public List list() throws NamingException {
        return null;
    }

    public String toString() {
        return "HessianModel[url= " + this.getURLPrefix() + ",name=" + this._namePrefix + "]";
    }
}

