/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.config.reflect.BaseTypeAnnotated;
import com.caucho.config.reflect.VarType;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;

@Module
public class NonBusinessMethodGenerator<X>
implements AspectGenerator<X> {
    private final AnnotatedMethod<? super X> _method;

    public NonBusinessMethodGenerator(AnnotatedMethod<? super X> method) {
        this._method = method;
        if (method.isStatic()) {
            throw new IllegalStateException();
        }
    }

    protected boolean isOverride() {
        return true;
    }

    public AnnotatedMethod<? super X> getMethod() {
        return this._method;
    }

    protected Set<VarType<?>> getTypeVariables() {
        BaseTypeAnnotated annType = (BaseTypeAnnotated)this.getMethod();
        Set varSet = annType.getTypeVariables();
        return varSet;
    }

    protected Method getJavaMethod() {
        return this._method.getJavaMember();
    }

    protected Class<?>[] getThrowsExceptions() {
        return this.getJavaMethod().getExceptionTypes();
    }

    public void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        int modifiers = this.getJavaMethod().getModifiers();
        String accessModifier = null;
        if (Modifier.isProtected(modifiers)) {
            accessModifier = "protected";
        } else if (Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers)) {
            throw new IllegalStateException(this.getJavaMethod().toString() + " must be protected or package protected");
        }
        String prefix = "";
        String suffix = "";
        String methodName = prefix + this.getJavaMethod().getName() + suffix;
        AspectGeneratorUtil.generateHeader((JavaWriter)out, (boolean)this.isOverride(), (String)accessModifier, (String)methodName, this.getMethod(), this.getTypeVariables(), (Class[])this.getThrowsExceptions());
        out.println("{");
        out.pushDepth();
        out.println("throw new EJBException(\"Illegal non-business method call\");");
        out.popDepth();
        out.println("}");
    }

    public void generateBeanPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
    }

    public void generateAsync(JavaWriter out) throws IOException {
    }

    public void generatePreTry(JavaWriter out) throws IOException {
    }

    public void generatePreCall(JavaWriter out) throws IOException {
    }

    public void generateCall(JavaWriter out) throws IOException {
    }

    public void generatePostCall(JavaWriter out) throws IOException {
    }

    public boolean isApplicationExceptionThrown() {
        return true;
    }

    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
    }

    public void generateSystemException(JavaWriter out, Class<?> exn) throws IOException {
    }

    public void generateFinally(JavaWriter out) throws IOException {
    }

    public void generatePostFinally(JavaWriter out) throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

