/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.gen.TransactionAttributeLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.reflect.BaseType;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.SingletonManager;
import com.caucho.ejb.session.StatefulManager;
import com.caucho.ejb.session.StatelessManager;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.rmi.Remote;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.SessionSynchronization;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.spi.AnnotatedType;

public class EjbSessionBean<X>
extends EjbBean<X> {
    private static final L10N L = new L10N(EjbSessionBean.class);
    private Class<? extends Annotation> _sessionType;

    public EjbSessionBean(EjbConfig ejbConfig, AnnotatedType<X> rawAnnType, AnnotatedType<X> annType, String ejbModuleName) {
        super(ejbConfig, rawAnnType, annType, ejbModuleName);
    }

    @Override
    public String getEJBKind() {
        return "session";
    }

    @Override
    public void setEJBClass(Class<X> type) throws ConfigException {
        super.setEJBClass(type);
        AnnotatedTypeImpl ejbClass = this.getAnnotatedType();
        Class ejbJavaClass = ejbClass.getJavaClass();
        if (Modifier.isAbstract(ejbJavaClass.getModifiers())) {
            throw this.error(L.l("'{0}' must not be abstract.  Session bean implementations must be fully implemented.", (Object)ejbJavaClass.getName()));
        }
        if (ejbClass.isAnnotationPresent(Stateless.class)) {
            Stateless stateless = (Stateless)ejbClass.getAnnotation(Stateless.class);
            if (this.getEJBName() == null && !"".equals(stateless.name())) {
                this.setEJBName(stateless.name());
            }
            this._sessionType = Stateless.class;
        } else if (ejbClass.isAnnotationPresent(Stateful.class)) {
            Stateful stateful = (Stateful)ejbClass.getAnnotation(Stateful.class);
            if (this.getEJBName() == null && !"".equals(stateful.name())) {
                this.setEJBName(stateful.name());
            }
            this._sessionType = Stateful.class;
        }
        if (this.getEJBName() == null) {
            this.setEJBName(ejbJavaClass.getSimpleName());
        }
    }

    public Class<? extends Annotation> getSessionType() {
        return this._sessionType;
    }

    @Override
    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (type.equals("Container")) {
            this._isContainerTransaction = true;
        } else if (type.equals("Bean")) {
            this._isContainerTransaction = false;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction-type.  transaction-type must be 'Container' or 'Bean'.", (Object)type));
        }
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        super.init();
        try {
            for (AnnotatedType remoteApi : this.getRemoteList()) {
                this.validateRemote(remoteApi);
            }
            for (AnnotatedType localApi : this.getLocalList()) {
                this.validateLocal(localApi);
            }
            if (this.getEJBClass() == null) {
                throw this.error(L.l("'{0}' does not have a defined ejb-class.  Session beans must have an ejb-class.", (Object)this.getEJBName()));
            }
            Class ejbClass = this.getAnnotatedType().getJavaClass();
            if (SessionSynchronization.class.isAssignableFrom(ejbClass)) {
                if (!Stateful.class.equals(this.getSessionType())) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Stateless session beans must not implement SessionSynchronization.", (Object)this.getEJBClass().getName()));
                }
                if (!this._isContainerTransaction) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Session beans with Bean-managed transactions may not use SessionSynchronization.", (Object)this.getEJBClass().getName()));
                }
            }
            this.fillClassDefaults();
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(this.getLocation() + e.getMessage(), (Throwable)e);
        }
    }

    protected void fillClassDefaults() {
        TransactionAttribute ann;
        AnnotatedTypeImpl ejbClass = this.getAnnotatedType();
        TransactionManagement tm = (TransactionManagement)ejbClass.getAnnotation(TransactionManagement.class);
        if ((tm == null || tm.value() == TransactionManagementType.CONTAINER) && (ann = (TransactionAttribute)ejbClass.getAnnotation(TransactionAttribute.class)) == null) {
            ejbClass.addAnnotation((Annotation)new TransactionAttributeLiteral(TransactionAttributeType.REQUIRED));
        }
    }

    @Override
    public void initIntrospect() throws ConfigException {
        javax.ejb.Remote remote;
        super.initIntrospect();
        AnnotatedTypeImpl type = this.getAnnotatedType();
        if (type == null) {
            return;
        }
        if (!(type.isAnnotationPresent(Stateful.class) || type.isAnnotationPresent(Stateless.class) || type.isAnnotationPresent(Singleton.class) || this.isAllowPOJO())) {
            return;
        }
        Class ejbClass = type.getJavaClass();
        ArrayList<BaseType> interfaceList = new ArrayList<BaseType>();
        this.addInterfaces(interfaceList, ejbClass, true);
        Local local = (Local)type.getAnnotation(Local.class);
        if (local != null && local.value() != null) {
            this._localList.clear();
            for (Class api : local.value()) {
                this.addLocal(api);
            }
        }
        if ((remote = (javax.ejb.Remote)type.getAnnotation(javax.ejb.Remote.class)) != null && remote.value() != null) {
            this._remoteList.clear();
            for (Class api : remote.value()) {
                this.addRemote(api);
            }
        }
        if (this._localList.size() == 0 && this._remoteList.size() == 0 && interfaceList.size() != 0) {
            if (interfaceList.size() != 1) {
                throw new ConfigException(L.l("'{0}' has multiple interfaces, but none are marked as @Local or @Remote.\n{1}", (Object)type.getJavaClass().getName(), (Object)interfaceList.toString()));
            }
            this.addLocalType(interfaceList.get(0));
        }
        if (type.isAnnotationPresent(LocalBean.class)) {
            this.setLocalBean(true);
        } else if (this._localList.size() == 0) {
            this.setLocalBean(true);
        }
    }

    private void addInterfaces(ArrayList<BaseType> interfaceList, Class<?> ejbClass, boolean isTop) {
        if (ejbClass == null) {
            return;
        }
        InjectManager cdiManager = InjectManager.getCurrent();
        for (Type localApi : ejbClass.getGenericInterfaces()) {
            BaseType type = cdiManager.createTargetBaseType(localApi);
            Class rawClass = type.getRawClass();
            Local local = rawClass.getAnnotation(Local.class);
            if (local != null) {
                this.addLocalType(type);
                continue;
            }
            javax.ejb.Remote remote = rawClass.getAnnotation(javax.ejb.Remote.class);
            if (remote != null || Remote.class.isAssignableFrom(rawClass)) {
                this.addRemoteType(type);
                continue;
            }
            if (rawClass.getName().equals("java.io.Serializable") || rawClass.getName().equals("java.io.Externalizable") || rawClass.getName().startsWith("javax.ejb") || rawClass.getName().equals("java.rmi.Remote") || !isTop) continue;
            this.addInterface(interfaceList, type);
        }
    }

    private void addInterface(ArrayList<BaseType> interfaceList, BaseType cl) {
        for (int i = interfaceList.size() - 1; i >= 0; --i) {
            BaseType oldClass = interfaceList.get(i);
            if (oldClass.isAssignableFrom(cl)) {
                interfaceList.set(i, cl);
                return;
            }
            if (!cl.isAssignableFrom(oldClass)) continue;
            return;
        }
        interfaceList.add(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractSessionManager<X> deployServer(EjbManager ejbContainer, EjbLazyGenerator<X> lazyGenerator) throws ClassNotFoundException, ConfigException {
        AbstractSessionManager manager;
        if (Stateless.class.equals(this.getSessionType())) {
            manager = new StatelessManager(ejbContainer, this.getEJBName(), this.getModuleName(), this.getRawAnnotatedType(), this.getAnnotatedType(), lazyGenerator);
        } else if (Stateful.class.equals(this.getSessionType())) {
            manager = new StatefulManager(ejbContainer, this.getEJBName(), this.getModuleName(), this.getRawAnnotatedType(), this.getAnnotatedType(), lazyGenerator);
        } else if (Singleton.class.equals(this.getSessionType())) {
            manager = new SingletonManager(ejbContainer, this.getEJBName(), this.getModuleName(), this.getRawAnnotatedType(), this.getAnnotatedType(), lazyGenerator);
        } else {
            throw new IllegalStateException(String.valueOf(this.getSessionType()));
        }
        manager.setMappedName(this.getMappedName());
        manager.setId(this.getEJBModuleName() + "#" + this.getEJBName());
        manager.setContainerTransaction(this._isContainerTransaction);
        manager.setResourceList(this.getResourceList());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)manager.getClassLoader());
            try {
                if (this.getServerProgram() != null) {
                    this.getServerProgram().configure((Object)manager);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return manager;
    }

    @Override
    protected String getBeanType() {
        return this.getSessionType().getSimpleName();
    }
}

