/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class EJBServlet
extends GenericServlet {
    private static final L10N L = new L10N(EJBServlet.class);
    private final Logger log = Logger.getLogger(EJBServlet.class.getName());
    private String _urlPrefix;
    private String _ejbServerJndiName = "java:comp/env/cmp";
    private String _containerId;
    private String _servletId;
    private String _localId;
    private boolean _isDebug;
    private Hashtable<CharSequence, Skeleton> _beanMap = new Hashtable();
    private EjbManager _ejbManager;
    private ProtocolContainer _protocolContainer;
    private ServletException _exception;
    private Path _workPath;

    protected String getDefaultProtocolContainer() {
        return "com.caucho.hessian.HessianProtocol";
    }

    public void setDebug(boolean debug) {
        this._isDebug = debug;
    }

    public void setURLPrefix(String prefix) {
        this._urlPrefix = prefix;
    }

    public void init() throws ServletException {
        this._ejbManager = EjbManager.getCurrent();
        if (this._ejbManager == null) {
            throw new ServletException(L.l("No <ejb-server> detected.  '{0}' requires a configured <ejb-server>", (Object)((Object)((Object)this)).getClass().getName()));
        }
        this._workPath = CauchoSystem.getWorkPath();
        this._urlPrefix = this.getInitParameter("url-prefix");
        this._localId = this.getInitParameter("local-prefix");
        String protocol = this.getInitParameter("protocol");
        if (protocol == null) {
            protocol = this.getInitParameter("protocol-container");
        }
        if (protocol == null) {
            protocol = this.getInitParameter("protocol-factory");
        }
        if (protocol == null) {
            protocol = this.getDefaultProtocolContainer();
        }
        try {
            Class cl = CauchoSystem.loadClass((String)protocol);
            this._protocolContainer = (ProtocolContainer)cl.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        WebApp app = (WebApp)this.getServletContext();
        this.initEjb();
        if (this._urlPrefix != null) {
            this.initProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        CauchoRequest req = (CauchoRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        if (this._urlPrefix == null) {
            EJBServlet eJBServlet = this;
            synchronized (eJBServlet) {
                if (this._urlPrefix == null) {
                    this.serverInit(req);
                }
            }
        }
        if (!req.getMethod().equals("POST")) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, (Object)((Object)this) + " unexpected method " + req.getMethod());
            }
            String protocol = this._protocolContainer.getName();
            res.setStatus(500, protocol + " Protocol Error");
            PrintWriter out = res.getWriter();
            out.println(protocol + " expects a POST containing an RPC call.");
            return;
        }
        try {
            Skeleton skeleton;
            String pathInfo = req.getPathInfo();
            String queryString = req.getQueryString();
            CharBuffer cb = new CharBuffer();
            cb.append(pathInfo);
            cb.append('?');
            cb.append(queryString);
            ServletInputStream is = req.getInputStream();
            if (this._isDebug) {
                // empty if block
            }
            if ((skeleton = this._beanMap.get(cb)) == null) {
                if (req.getParameter("ejb-load") != null) {
                    return;
                }
                if (this._exception != null) {
                    throw this._exception;
                }
                try {
                    if (pathInfo == null) {
                        pathInfo = "";
                    }
                    skeleton = this._protocolContainer.getSkeleton(pathInfo, queryString);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, e.toString(), e);
                    skeleton = this._protocolContainer.getExceptionSkeleton();
                    if (skeleton != null) {
                        skeleton._service((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream(), e);
                        return;
                    }
                    throw e;
                }
                if (skeleton == null) {
                    throw new ServletException(L.l("Can't load skeleton for '{0}?{1}'", (Object)pathInfo, (Object)queryString));
                }
                if (skeleton != null) {
                    skeleton.setDebug(this._isDebug);
                    this._beanMap.put((CharSequence)cb, skeleton);
                }
            }
            skeleton._service((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream());
        }
        catch (ServletException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.log(Level.WARNING, e.toString(), e);
            throw new ServletException(e);
        }
    }

    Skeleton getSkeleton(String pathInfo, String queryString) throws Exception {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(pathInfo);
        cb.append('?');
        cb.append(queryString);
        Skeleton skeleton = this._beanMap.get(cb);
        if (skeleton != null) {
            cb.free();
            return skeleton;
        }
        skeleton = this._protocolContainer.getSkeleton(pathInfo, queryString);
        this._beanMap.put((CharSequence)cb, skeleton);
        return skeleton;
    }

    private void serverInit(CauchoRequest req) throws ServletException {
        if (this._urlPrefix != null) {
            return;
        }
        WebApp app = (WebApp)this.getServletContext();
        this._servletId = req.getServletPath();
        CharBuffer cb = CharBuffer.allocate();
        if (!"default".equals(app.getAdmin().getHost().getName()) && !"".equals(app.getAdmin().getHost().getName())) {
            String hostName = app.getAdmin().getHost().getURL();
            cb.append(hostName);
            cb.append(app.getContextPath());
            cb.append(this._servletId);
        } else {
            cb.append(req.getScheme());
            cb.append("://");
            cb.append(req.getServerName());
            cb.append(":");
            cb.append(req.getServerPort());
            cb.append(app.getContextPath());
            cb.append(this._servletId);
        }
        this._urlPrefix = cb.close();
        this.initProtocol();
    }

    private void initProtocol() {
        this.normalizeId();
        this._protocolContainer.setProtocolManager(this._ejbManager.getProtocolManager());
        this._protocolContainer.setURLPrefix(this._urlPrefix);
        this._protocolContainer.setWorkPath(this._workPath);
        for (EjbManager manager = this._ejbManager; manager != null; manager = manager.getParent()) {
            manager.getProtocolManager().addProtocolContainer(this._protocolContainer);
        }
    }

    private void normalizeId() {
        if (this._urlPrefix == null) {
            return;
        }
        WebApp application = (WebApp)this.getServletContext();
        String hostName = "localhost";
        String contextPath = application.getContextPath();
        if (this._urlPrefix.startsWith("/")) {
            this._servletId = this._urlPrefix;
            this._urlPrefix = application.getURL() + this._urlPrefix;
        } else if (this._urlPrefix.startsWith("http://")) {
            int p = this._urlPrefix.indexOf(47, "http://".length());
            String uri = this._urlPrefix;
            uri = p > 0 ? this._urlPrefix.substring(p) : "";
            if (uri.startsWith(contextPath)) {
                this._servletId = uri.substring(contextPath.length());
            } else if (this._servletId == null) {
                this._servletId = uri;
            }
        } else if (this._urlPrefix.startsWith("https://")) {
            int p = this._urlPrefix.indexOf(47, "https://".length());
            String uri = this._urlPrefix;
            uri = p > 0 ? this._urlPrefix.substring(p) : "";
            if (uri.startsWith(contextPath)) {
                this._servletId = uri.substring(contextPath.length());
            } else if (this._servletId == null) {
                this._servletId = uri;
            }
        } else if (this._urlPrefix.startsWith("cron:")) {
            this._urlPrefix = application.getURL() + this._servletId;
        } else {
            this._servletId = this._urlPrefix;
        }
        if (this._servletId.equals("")) {
            this._servletId = "/";
        }
    }

    private void initEjb() throws ServletException {
        if (this._ejbManager != null) {
            return;
        }
        if (this._urlPrefix != null) {
            this.normalizeId();
            this._protocolContainer.setServerManager(this._ejbManager);
            this._protocolContainer.setURLPrefix(this._urlPrefix);
            this._protocolContainer.setWorkPath(this._workPath);
            for (EjbManager manager = this._ejbManager; manager != null; manager = manager.getParent()) {
                manager.getProtocolManager().addProtocolContainer(this._protocolContainer);
            }
        }
    }

    public void destroy() {
        for (EjbManager manager = this._ejbManager; manager != null; manager = manager.getParent()) {
            manager.getProtocolManager().removeProtocolContainer(this._protocolContainer);
        }
    }
}

