/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.L10N;
import java.sql.SQLException;

class IdentityColumn
extends Column {
    private static final L10N L = new L10N(IdentityColumn.class);

    IdentityColumn(Row row, String name) {
        super(row, name);
        this.setPrimaryKey(true);
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.IDENTITY;
    }

    @Override
    public Class<?> getJavaType() {
        return Long.TYPE;
    }

    @Override
    public int getDeclarationSize() {
        return 0;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public boolean isNull(byte[] block, int rowOffset) {
        return false;
    }

    @Override
    void setString(DbTransaction xa, byte[] block, int rowOffset, String str) {
        throw new IllegalStateException(L.l("an IDENTITY column cannot be set"));
    }

    @Override
    public String getString(long blockId, byte[] block, int rowOffset) {
        return "0x" + Long.toHexString(this.getLong(blockId, block, rowOffset));
    }

    @Override
    void setInteger(DbTransaction xa, byte[] block, int rowOffset, int value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getInteger(long blockId, byte[] block, int rowOffset) {
        return (int)this.getLong(blockId, block, rowOffset);
    }

    @Override
    void setLong(DbTransaction xa, byte[] block, int rowOffset, long value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getLong(long blockId, byte[] block, int rowOffset) {
        return (blockId & 0xFFFFFFFFFFFFE000L) + (long)rowOffset;
    }

    @Override
    public double getDouble(long blockId, byte[] block, int rowOffset) {
        return this.getLong(blockId, block, rowOffset);
    }

    @Override
    void setExpr(DbTransaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        long value = expr.evalLong(context);
    }

    @Override
    public void set(DbTransaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) {
        result.writeLong((blockId & 0xFFFFFFFFFFFFE000L) + (long)rowOffset);
    }

    @Override
    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

