/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.db.blob.BlobOutputStream;
import com.caucho.db.blob.Inode;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class BlobColumn
extends Column {
    private static final Logger log = Logger.getLogger(BlobColumn.class.getName());

    BlobColumn(Row row, String name) {
        super(row, name);
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.BLOB;
    }

    @Override
    public Class<?> getJavaType() {
        return Blob.class;
    }

    @Override
    public int getDeclarationSize() {
        return 128;
    }

    @Override
    public int getLength() {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setString(DbTransaction xa, byte[] block, int rowOffset, String str) {
        long length;
        if (!this.isNull(block, rowOffset) && 120L <= (length = Inode.readLong(block, rowOffset + this._columnOffset))) {
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            xa.addDeleteInode(inode);
        }
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        this.setNonNull(block, rowOffset);
        BlobOutputStream os = null;
        try {
            os = new BlobOutputStream(xa, this.getTable(), block, rowOffset + this._columnOffset);
            int length2 = str.length();
            for (int i = 0; i < length2; ++i) {
                char ch = str.charAt(i);
                if (ch < '\u0080') {
                    os.write(ch);
                    continue;
                }
                if (ch < '\u0800') {
                    os.write(192 + (ch >> 6));
                    os.write(128 + (ch & 0x3F));
                    continue;
                }
                os.write(224 + (ch >> 12));
                os.write(128 + (ch >> 6 & 0x3F));
                os.write(128 + (ch & 0x3F));
            }
            IoUtil.close((OutputStream)os);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            IoUtil.close(os);
        }
    }

    private void setStream(DbTransaction xa, byte[] block, int rowOffset, InputStream value) {
        long length;
        if (!this.isNull(block, rowOffset) && 120L <= (length = Inode.readLong(block, rowOffset + this._columnOffset))) {
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            xa.addDeleteInode(inode);
        }
        if (value == null) {
            this.setNull(block, rowOffset);
            return;
        }
        this.setNonNull(block, rowOffset);
        try {
            BlobOutputStream os = new BlobOutputStream(xa, this.getTable(), block, rowOffset + this._columnOffset);
            os.writeFromStream(value);
            os.close();
            value.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    void deleteData(DbTransaction xa, byte[] block, int rowOffset) throws SQLException {
        if (!this.isNull(block, rowOffset)) {
            long length = Inode.readLong(block, rowOffset + this._columnOffset);
            if (length < 120L) {
                return;
            }
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            this.setNull(block, rowOffset);
            inode.remove();
        }
    }

    @Override
    public String getString(long blockId, byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        try {
            int ch;
            BlobInputStream is = new BlobInputStream(this.getTable(), block, rowOffset + this._columnOffset);
            StringBuilder cb = new StringBuilder();
            while ((ch = is.read()) >= 0) {
                int ch1;
                if (ch < 128) {
                    cb.append((char)ch);
                    continue;
                }
                if ((ch & 0xE0) == 192) {
                    ch1 = is.read();
                    cb.append((char)(((ch & 0x3F) << 6) + (ch1 & 0x3F)));
                    continue;
                }
                ch1 = is.read();
                int ch2 = is.read();
                cb.append((char)(((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)));
            }
            is.close();
            return cb.toString();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public void set(DbTransaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        byte[] block = iter.getBuffer();
        int rowOffset = iter.getRowOffset();
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else if (expr.isBinaryStream(context)) {
            this.setStream(xa, block, rowOffset, expr.evalStream(context));
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
        iter.setDirty();
    }

    @Override
    void setExpr(DbTransaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
    }

    @Override
    void setExprBlob(DbTransaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else if (expr.isBinaryStream(context)) {
            this.setStream(xa, block, rowOffset, expr.evalStream(context));
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    @Override
    public boolean isValid(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return true;
        }
        return Inode.isValid(this.getTable(), block, rowOffset + this._columnOffset);
    }

    @Override
    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        for (int i = 127; i >= 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isEqual(long blockId, byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        return false;
    }

    @Override
    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeBlob(block, rowOffset + this._columnOffset);
    }

    @Override
    public String toString() {
        return "BlobColumn[" + this.getName() + "]";
    }
}

