/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.block.Block;
import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Data;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.inject.Module;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.NullIterator;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class QueryContext {
    private static final Logger log = Logger.getLogger(QueryContext.class.getName());
    private static final L10N L = new L10N(QueryContext.class);
    private static final long LOCK_TIMEOUT = 120000L;
    private static final FreeList<QueryContext> _freeList = new FreeList(64);
    private DbTransaction _xa;
    private TableIterator[] _tableIterators;
    private boolean _isWrite;
    private Data[] _parameters = new Data[16];
    private GroupItem _tempGroupItem;
    private GroupItem _groupItem;
    private boolean _isReturnGeneratedKeys;
    private SelectResult _result;
    private GeneratedKeysResultSet _generatedKeys;
    private int _rowUpdateCount;
    private int _limit = -1;
    private Block[] _blockLocks;
    private int _blockLockLength;
    private boolean _isLocked;
    private boolean _isNonLocking;
    private HashMap<GroupItem, GroupItem> _groupMap;
    private byte[] _buffer = new byte[256];
    private Thread _thread;

    private QueryContext() {
        this._tempGroupItem = GroupItem.allocate(new boolean[8]);
    }

    public static QueryContext allocate() {
        QueryContext queryContext = (QueryContext)_freeList.allocate();
        if (queryContext == null) {
            queryContext = new QueryContext();
        }
        queryContext.clearParameters();
        queryContext._limit = -1;
        queryContext._isNonLocking = false;
        return queryContext;
    }

    public void setNonLocking() {
        this._isNonLocking = true;
    }

    public void clearParameters() {
        for (int i = this._parameters.length - 1; i >= 0; --i) {
            if (this._parameters[i] == null) {
                this._parameters[i] = new Data();
            }
            this._parameters[i].clear();
        }
    }

    public void init(DbTransaction xa, TableIterator[] tableIterators, boolean isReadOnly) {
        if (this._isLocked) {
            throw new IllegalStateException();
        }
        Thread thread = Thread.currentThread();
        if (this._thread != null && this._thread != thread) {
            throw new IllegalStateException(this.toString() + " attempted query reuse without close");
        }
        this._thread = thread;
        this._xa = xa;
        this._isWrite = !isReadOnly;
        this._tableIterators = tableIterators;
        this._blockLockLength = tableIterators.length;
        if (this._blockLocks == null || this._blockLocks.length < this._blockLockLength) {
            this._blockLocks = new Block[this._blockLockLength];
        } else {
            for (int i = this._blockLockLength - 1; i >= 0; --i) {
                this._blockLocks[i] = null;
            }
        }
        this._rowUpdateCount = 0;
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(0, null);
    }

    public void initGroup(int size, boolean[] isGroupByFields) {
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(size, isGroupByFields);
        if (this._groupMap == null) {
            this._groupMap = new HashMap();
        }
    }

    public void selectGroup() {
        GroupItem item = this._groupMap.get(this._groupItem);
        if (item == null) {
            item = this._groupItem.allocateCopy();
            this._groupMap.put(item, item);
        }
        this._groupItem = item;
    }

    Iterator<GroupItem> groupResults() {
        if (this._groupMap == null) {
            return NullIterator.create();
        }
        Iterator<GroupItem> results = this._groupMap.values().iterator();
        this._groupMap = null;
        return results;
    }

    void setGroupItem(GroupItem item) {
        this._groupItem = item;
    }

    public TableIterator[] getTableIterators() {
        return this._tableIterators;
    }

    public void setTransaction(DbTransaction xa) {
        this._xa = xa;
    }

    public DbTransaction getTransaction() {
        return this._xa;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public int getRowUpdateCount() {
        return this._rowUpdateCount;
    }

    public void setRowUpdateCount(int count) {
        this._rowUpdateCount = count;
    }

    public boolean isReturnGeneratedKeys() {
        return this._isReturnGeneratedKeys;
    }

    public void setReturnGeneratedKeys(boolean isReturnGeneratedKeys) {
        this._isReturnGeneratedKeys = isReturnGeneratedKeys;
        if (this._isReturnGeneratedKeys && this._generatedKeys != null) {
            this._generatedKeys.init();
        }
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public int getLimit() {
        return this._limit;
    }

    public boolean isGroupNull(int index) {
        return this._groupItem.isNull(index);
    }

    public void setGroupString(int index, String value) {
        this._groupItem.setString(index, value);
    }

    public String getGroupString(int index) {
        String value = this._groupItem.getString(index);
        return value;
    }

    public void setGroupLong(int index, long value) {
        this._groupItem.setLong(index, value);
    }

    public long getGroupLong(int index) {
        return this._groupItem.getLong(index);
    }

    public void setGroupDouble(int index, double value) {
        this._groupItem.setDouble(index, value);
    }

    public double getGroupDouble(int index) {
        return this._groupItem.getDouble(index);
    }

    public Data getGroupData(int index) {
        return this._groupItem.getData(index);
    }

    public void setNull(int index) {
        this._parameters[index - 1].setString(null);
    }

    public boolean isNull(int index) {
        return this._parameters[index - 1].isNull();
    }

    public void setLong(int index, long value) {
        this._parameters[index - 1].setLong(value);
    }

    public int getBoolean(int index) {
        return this._parameters[index - 1].getBoolean();
    }

    public void setBoolean(int index, boolean value) {
        this._parameters[index - 1].setBoolean(value);
    }

    public long getLong(int index) {
        return this._parameters[index - 1].getLong();
    }

    public long getDate(int index) {
        return this._parameters[index - 1].getDate();
    }

    public void setDate(int index, long date) {
        this._parameters[index - 1].setDate(date);
    }

    public void setDouble(int index, double value) {
        this._parameters[index - 1].setDouble(value);
    }

    public double getDouble(int index) {
        return this._parameters[index - 1].getDouble();
    }

    public void setString(int index, String value) {
        this._parameters[index - 1].setString(value);
    }

    public String getString(int index) {
        return this._parameters[index - 1].getString();
    }

    public boolean isBinaryStream(int index) {
        return this._parameters[index - 1].isBinaryStream();
    }

    public void setBinaryStream(int index, InputStream is, int length) {
        this._parameters[index - 1].setBinaryStream(is, length);
    }

    public InputStream getBinaryStream(int index) {
        return this._parameters[index - 1].getBinaryStream();
    }

    public void setBytes(int index, byte[] bytes) {
        this._parameters[index - 1].setBytes(bytes);
    }

    public byte[] getBytes(int index) {
        return this._parameters[index - 1].getBytes();
    }

    public Column.ColumnType getType(int index) {
        return this._parameters[index - 1].getType();
    }

    public void setResult(SelectResult result) {
        this._result = result;
    }

    public SelectResult getResult() {
        return this._result;
    }

    public GeneratedKeysResultSet getGeneratedKeysResultSet() {
        if (!this._isReturnGeneratedKeys) {
            return null;
        }
        if (this._generatedKeys == null) {
            this._generatedKeys = new GeneratedKeysResultSet();
        }
        return this._generatedKeys;
    }

    public boolean lock() throws SQLException {
        if (this._isNonLocking) {
            return true;
        }
        if (this._isLocked) {
            throw new IllegalStateException(L.l("blocks are already locked"));
        }
        this._isLocked = true;
        try {
            Lock tableLock = this._tableIterators[0].getTable().getTableLock();
            if (this._isWrite) {
                return tableLock.tryLock(this._xa.getTimeout(), TimeUnit.MILLISECONDS);
            }
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws SQLException {
        if (this._isNonLocking) {
            return;
        }
        if (!this._isLocked) {
            return;
        }
        this._isLocked = false;
        int len = this._blockLocks.length;
        Lock tableLock = this._tableIterators[0].getTable().getTableLock();
        if (this._isWrite) {
            try {
                tableLock.unlock();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        try {
            this._xa.writeData();
        }
        catch (Throwable throwable) {
            for (int i = len - 1; i >= 0; --i) {
                Block block = this._blockLocks[i];
                this._blockLocks[i] = null;
                if (block == null || !this._isWrite) continue;
                try {
                    block.commit();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            throw throwable;
        }
        for (int i = len - 1; i >= 0; --i) {
            Block block = this._blockLocks[i];
            this._blockLocks[i] = null;
            if (block == null || !this._isWrite) continue;
            try {
                block.commit();
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public void lockOld() throws SQLException {
        if (this._isNonLocking) {
            return;
        }
        if (this._isLocked) {
            throw new IllegalStateException(L.l("blocks are already locked"));
        }
        this._isLocked = true;
        if (this._thread != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        int len = this._tableIterators.length;
        for (int i = 0; i < len; ++i) {
            Block bestBlock = null;
            long bestId = Long.MAX_VALUE;
            block3: for (int j = 0; j < len; ++j) {
                long id;
                Block block;
                TableIterator iter = this._tableIterators[j];
                if (iter == null || (block = iter.getBlock()) == null || bestId <= (id = block.getBlockId())) continue;
                for (int k = 0; k < i; ++k) {
                    if (this._blockLocks[k] == block) continue block3;
                }
                bestId = id;
                bestBlock = block;
            }
            try {
                if (bestBlock != null) {
                    if (this._isWrite) {
                        bestBlock.getWriteLock().tryLock(this._xa.getTimeout(), TimeUnit.MILLISECONDS);
                    } else {
                        bestBlock.getReadLock().tryLock(this._xa.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this._blockLocks[i] = bestBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockOld() throws SQLException {
        Block block;
        int i;
        if (this._isNonLocking) {
            return;
        }
        if (!this._isLocked) {
            return;
        }
        this._isLocked = false;
        if (this._thread != null && this._thread != Thread.currentThread()) {
            throw new IllegalStateException(String.valueOf(this._thread) + " current " + Thread.currentThread());
        }
        int len = this._blockLocks.length;
        for (i = len - 1; i >= 0; --i) {
            block = this._blockLocks[i];
            if (block == null) continue;
            if (this._isWrite) {
                block.getWriteLock().unlock();
                continue;
            }
            block.getReadLock().unlock();
        }
        try {
            this._xa.writeData();
        }
        catch (Throwable throwable) {
            for (int i2 = len - 1; i2 >= 0; --i2) {
                Block block2 = this._blockLocks[i2];
                this._blockLocks[i2] = null;
                if (block2 == null || !this._isWrite) continue;
                try {
                    block2.commit();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            throw throwable;
        }
        for (i = len - 1; i >= 0; --i) {
            block = this._blockLocks[i];
            this._blockLocks[i] = null;
            if (block == null || !this._isWrite) continue;
            try {
                block.commit();
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public void close() throws SQLException {
        Thread thread = this._thread;
        this._thread = null;
        this.unlock();
        if (thread != null && thread != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        if (this._isLocked) {
            throw new IllegalStateException();
        }
        DbTransaction xa = this._xa;
        this._xa = null;
        if (xa != null && xa.isAutoCommit()) {
            xa.commit();
        }
    }

    public static void free(QueryContext cxt) {
        _freeList.free((Object)cxt);
    }
}

