/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.SelectResult;
import com.caucho.util.IntArray;
import java.sql.SQLException;

abstract class Order {
    private boolean _isAscending = true;
    protected Order _next;

    Order() {
    }

    public boolean isAscending() {
        return this._isAscending;
    }

    public void setAscending(boolean isAscending) {
        this._isAscending = isAscending;
    }

    static Order append(Order order, Order next) {
        if (order == null) {
            return next;
        }
        order._next = next;
        return order;
    }

    public abstract int compare(SelectResult var1, int var2, int var3) throws SQLException;

    public void sort(SelectResult result, IntArray rowArray) throws SQLException {
        int[] rows = rowArray.getArray();
        int size = rowArray.size();
        this.sort(result, rows, 0, size);
    }

    private void sort(SelectResult result, int[] rows, int offset, int length) throws SQLException {
        if (length > 3) {
            int right;
            int head = offset;
            int tail = right = offset + length - 1;
            int pivot = offset + length / 2;
            int pivotIndex = rows[pivot];
            int temp = rows[right];
            rows[right] = pivotIndex;
            rows[pivot] = temp;
            --tail;
            while (true) {
                if (head <= tail && this.compare(result, rows[head], pivotIndex) < 0) {
                    ++head;
                    continue;
                }
                while (head <= tail && this.compare(result, rows[tail], pivotIndex) > 0) {
                    --tail;
                }
                if (head > tail) break;
                temp = rows[head];
                rows[head++] = rows[tail];
                rows[tail--] = temp;
            }
            if (this.compare(result, rows[head], pivotIndex) > 0) {
                temp = rows[head];
                rows[head] = rows[right];
                rows[right] = temp;
            }
            if (offset < head) {
                this.sort(result, rows, offset, head - offset);
            }
            if (right > head) {
                this.sort(result, rows, head + 1, right - head);
            }
        } else if (length == 3) {
            int temp;
            int indexA = rows[offset + 0];
            int indexB = rows[offset + 1];
            int indexC = rows[offset + 2];
            if (this.compare(result, indexB, indexA) < 0) {
                temp = indexA;
                indexA = indexB;
                indexB = temp;
            }
            if (this.compare(result, indexB, indexC) > 0) {
                if (this.compare(result, indexC, indexA) < 0) {
                    temp = indexC;
                    indexC = indexB;
                    indexB = indexA;
                    indexA = temp;
                } else {
                    temp = indexC;
                    indexC = indexB;
                    indexB = temp;
                }
            }
            rows[offset + 0] = indexA;
            rows[offset + 1] = indexB;
            rows[offset + 2] = indexC;
        } else if (length == 2) {
            int indexB = rows[offset + 1];
            int indexA = rows[offset];
            if (this.compare(result, indexB, indexA) < 0) {
                int temp = indexB;
                indexB = indexA;
                indexA = temp;
            }
            rows[offset + 0] = indexA;
            rows[offset + 1] = indexB;
        }
    }
}

