/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class ConcatExpr
extends Expr {
    private Expr _left;
    private Expr _right;

    ConcatExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._left = this._left.bind(query);
        this._right = this._right.bind(query);
        return this;
    }

    public Class getType() {
        return String.class;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        String leftValue = this._left.evalString(context);
        String rightValue = this._right.evalString(context);
        if (leftValue == null) {
            return rightValue;
        }
        if (rightValue == null) {
            return leftValue;
        }
        return leftValue + rightValue;
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return "(" + this._left + " || " + this._right + ")";
    }
}

