/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.AbstractBinaryBooleanExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;

final class BinaryAndExpr
extends AbstractBinaryBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    BinaryAndExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    public final Expr getLeft() {
        return this._left;
    }

    @Override
    public final Expr getRight() {
        return this._right;
    }

    @Override
    public Expr create(Expr left, Expr right) {
        return new BinaryAndExpr(left, right);
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        if (!newLeft.getType().equals(Boolean.TYPE)) {
            throw new SQLException(L.l("AND requires boolean operands at {0}", (Object)newLeft));
        }
        Expr newRight = this._right.bind(query);
        if (!newRight.getType().equals(Boolean.TYPE)) {
            throw new SQLException(L.l("AND requires boolean operands at {0}", (Object)newRight));
        }
        return this.create(newLeft, newRight);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        int leftValue = this._left.evalBoolean(context);
        if (leftValue == 0) {
            return false;
        }
        int rightValue = this._right.evalBoolean(context);
        if (rightValue == 0) {
            return false;
        }
        return leftValue == -1 || rightValue == -1;
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        int leftValue = this._left.evalBoolean(context);
        if (leftValue == 0) {
            return 0;
        }
        int rightValue = this._right.evalBoolean(context);
        if (rightValue == 0) {
            return 0;
        }
        if (leftValue == -1 || rightValue == -1) {
            return -1;
        }
        return 1;
    }

    @Override
    public final boolean isSelect(QueryContext context) throws SQLException {
        return this._left.isSelect(context) && this._right.isSelect(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this.evalBoolean(context)) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    public String toString() {
        return "(" + this._left + " AND " + this._right + ")";
    }
}

