/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SumExpr;
import com.caucho.util.L10N;
import java.sql.SQLException;

public class AvgExpr
extends FunExpr
implements GroupExpr {
    protected static final L10N L = new L10N(SumExpr.class);
    private Expr _expr;
    private int _groupField;

    @Override
    protected void addArg(Expr expr) throws SQLException {
        if (this._expr != null) {
            throw new SQLException(L.l("sum requires a single argument"));
        }
        this._expr = expr;
    }

    public Class getType() {
        return Double.TYPE;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._groupField = query.getDataFields();
        query.setDataFields(this._groupField + 2);
        query.setGroup(true);
        this._expr = this._expr.bind(query);
        return this;
    }

    @Override
    public void initGroup(QueryContext context) throws SQLException {
        context.setGroupDouble(this._groupField, 0.0);
        context.setGroupDouble(this._groupField + 1, 0.0);
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return;
        }
        double count = context.getGroupDouble(this._groupField);
        context.setGroupDouble(this._groupField, count + 1.0);
        double value = this._expr.evalDouble(context);
        double sum = context.getGroupDouble(this._groupField + 1);
        context.setGroupDouble(this._groupField + 1, sum + value);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return context.isGroupNull(this._groupField);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        double count = context.getGroupDouble(this._groupField);
        if (count == 0.0) {
            return 0.0;
        }
        return context.getGroupDouble(this._groupField + 1) / count;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return (long)this.evalDouble(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalDouble(context));
    }
}

