/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.jdbc.NullResultSet;
import com.caucho.db.jdbc.ResultSetImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementImpl
implements Statement {
    private static final L10N L = new L10N(StatementImpl.class);
    protected Database _db;
    protected final ConnectionImpl _conn;
    protected ResultSetImpl _rs;
    private QueryContext _queryContext;

    StatementImpl(ConnectionImpl conn) {
        this._conn = conn;
        this._db = conn.getDatabase();
        if (this._db == null) {
            throw new NullPointerException();
        }
        this._queryContext = QueryContext.allocate();
        this.init();
    }

    protected void init() {
    }

    protected Database getDatabase() {
        return this._db;
    }

    protected ConnectionImpl getConnectionImpl() {
        return this._conn;
    }

    protected QueryContext getQueryContext() {
        return this._queryContext;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this._db == null) {
            throw new SQLException(L.l("statement is closed"));
        }
        Query query = this._db.parseQuery(sql);
        ResultSet rs = this.executeQuery(query, this._queryContext);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(Query query, QueryContext queryContext) throws SQLException {
        DbTransaction xa = this._conn.getTransaction();
        boolean isOkay = false;
        try {
            query.execute(queryContext, xa);
            isOkay = true;
        }
        finally {
            if (xa.isAutoCommit()) {
                if (isOkay) {
                    xa.commit();
                } else {
                    xa.rollback();
                }
            }
        }
        this._rs = new ResultSetImpl(this, queryContext.getResult());
        return this._rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(Query query) throws SQLException {
        DbTransaction xa = this._conn.getTransaction();
        boolean isOkay = false;
        int rowUpdateCount = 0;
        try {
            this._queryContext.setTransaction(xa);
            query.execute(this._queryContext, xa);
            rowUpdateCount = this._queryContext.getRowUpdateCount();
            isOkay = true;
        }
        finally {
            if (xa.isAutoCommit()) {
                if (isOkay) {
                    xa.commit();
                } else {
                    xa.rollback();
                }
            }
        }
        return rowUpdateCount;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        GeneratedKeysResultSet rs = this._queryContext.getGeneratedKeysResultSet();
        if (rs != null) {
            return rs;
        }
        return new NullResultSet();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        if (query instanceof SelectQuery) {
            this.executeQuery(query, this._queryContext);
            return true;
        }
        this.executeUpdate(query);
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet() {
        return this._rs;
    }

    @Override
    public int getUpdateCount() {
        return this._queryContext.getRowUpdateCount();
    }

    @Override
    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public int getFetchSize() {
        return this._queryContext.getLimit();
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }

    @Override
    public int getResultSetType() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public void setFetchSize(int rows) {
        this._queryContext.setLimit(rows);
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public boolean getMoreResults(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        return this.execute(query);
    }

    @Override
    public boolean execute(String query, int[] foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String query, String[] foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this._db = null;
        ResultSetImpl rs = this._rs;
        this._rs = null;
        if (rs != null) {
            rs.close();
        }
        QueryContext queryContext = this._queryContext;
        this._queryContext = null;
        if (queryContext != null) {
            QueryContext.free(queryContext);
        }
        this._conn.closeStatement(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._db + "]";
    }
}

