/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.index.BTree;
import com.caucho.db.index.IndexKey;
import com.caucho.db.xa.DbTransaction;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IndexCache {
    private static final Logger log = Logger.getLogger(IndexCache.class.getName());
    private static final L10N L = new L10N(IndexCache.class);
    private static IndexCache _staticCache;
    private final LruCache<IndexKey, IndexKey> _cache;
    private final ArrayList<IndexKey> _writeQueue = new ArrayList();
    private final AtomicReference<IndexKey> _freeKey = new AtomicReference();
    private IndexCacheWriter _indexWriter = new IndexCacheWriter();

    private IndexCache(int capacity) {
        this._cache = new LruCache(capacity);
    }

    public static IndexCache create() {
        if (_staticCache == null) {
            int size = CurrentTime.isTest() ? 8192 : 65536;
            _staticCache = new IndexCache(size);
        }
        return _staticCache;
    }

    public static IndexCache getCurrent() {
        return _staticCache;
    }

    public long lookup(BTree btree, byte[] buffer, int offset, int length, DbTransaction xa) throws SQLException {
        long btreeValue;
        IndexKey value = this.lookupValue(btree, buffer, offset, length);
        if (value != null && value.isValid()) {
            return value.getValue();
        }
        try {
            btreeValue = btree.lookup(buffer, offset, length);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        value = IndexKey.create(btree, buffer, offset, length, btreeValue);
        value.setValid(true);
        this._cache.compareAndPut(null, (Object)value, (Object)value);
        return btreeValue;
    }

    public void insert(BTree btree, byte[] buffer, int offset, int length, long value, DbTransaction xa) throws SQLException {
        long btreeValue;
        IndexKey key = IndexKey.create(btree, buffer, offset, length, value);
        if (!this._cache.compareAndPut(null, (Object)key, (Object)key)) {
            throw new SQLException(L.l("duplicate key exception"));
        }
        try {
            btreeValue = btree.lookup(buffer, offset, length);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        if (btreeValue != 0L) {
            key.setValue(btreeValue);
            key.setValid(true);
            throw new SQLException(L.l("duplicate key exception"));
        }
        key.setValid(true);
    }

    public void delete(BTree btree, byte[] buffer, int offset, int length, DbTransaction xa) throws SQLException {
        IndexKey value = this.lookupValue(btree, buffer, offset, length);
        if (value != null) {
            value.setValue(0L);
        } else {
            btree.remove(buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexKey lookupValue(BTree btree, byte[] buffer, int offset, int length) {
        IndexKey key = this._freeKey.getAndSet(null);
        if (key == null) {
            key = new IndexKey();
        }
        key.init(btree, buffer, offset, length);
        IndexKey value = (IndexKey)this._cache.get((Object)key);
        if (value == null) {
            ArrayList<IndexKey> arrayList = this._writeQueue;
            synchronized (arrayList) {
                int size = this._writeQueue.size();
                for (int i = 0; i < size; ++i) {
                    IndexKey writeKey = this._writeQueue.get(i);
                    if (!key.equals(writeKey)) continue;
                    value = writeKey;
                    this._cache.compareAndPut(null, (Object)value, (Object)value);
                }
            }
        }
        this._freeKey.set(key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWrite(IndexKey key) {
        ArrayList<IndexKey> arrayList;
        key.setStored(true);
        while (this._writeQueue.size() > 1024) {
            this._indexWriter.wake();
            arrayList = this._writeQueue;
            synchronized (arrayList) {
                if (this._writeQueue.size() > 1024) {
                    try {
                        this._writeQueue.wait(1000L);
                    }
                    catch (Exception e) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                }
            }
        }
        arrayList = this._writeQueue;
        synchronized (arrayList) {
            this._writeQueue.add(key);
        }
        this._indexWriter.wake();
    }

    class IndexCacheWriter
    extends AbstractTaskWorker {
        IndexCacheWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long runTask() {
            DbTransaction xa = DbTransaction.create();
            try {
                IndexKey key = null;
                Thread.interrupted();
                ArrayList arrayList = IndexCache.this._writeQueue;
                synchronized (arrayList) {
                    if (IndexCache.this._writeQueue.size() == 0) {
                        return -1L;
                    }
                    key = (IndexKey)IndexCache.this._writeQueue.get(0);
                }
                if (key != null) {
                    BTree btree = key.getBTree();
                    long value = key.getValue();
                    if (key.isStored()) {
                        if (value != 0L) {
                            btree.insert(key.getBuffer(), key.getOffset(), key.getLength(), value, true);
                        } else {
                            btree.remove(key.getBuffer(), key.getOffset(), key.getLength());
                        }
                    }
                }
                arrayList = IndexCache.this._writeQueue;
                synchronized (arrayList) {
                    if (key != null) {
                        IndexCache.this._writeQueue.remove(0);
                    }
                    IndexCache.this._writeQueue.notify();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            return -1L;
        }
    }
}

