/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.BlockManager;
import com.caucho.db.block.BlockStore;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeRing;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockReadWrite {
    private static final Logger log = Logger.getLogger(BlockReadWrite.class.getName());
    private static final L10N L = new L10N(BlockReadWrite.class);
    private static final long FILE_SIZE_INCREMENT = 0x800000L;
    private final BlockStore _store;
    private final BlockManager _blockManager;
    private Path _path;
    private long _fileSize;
    private Object _fileLock = new Object();
    private AtomicReference<RandomAccessStream> _mmapFile = new AtomicReference();
    private boolean _isEnableMmap = true;
    private boolean _isMmap = false;
    private FreeRing<RandomAccessWrapper> _cachedRowFile = new FreeRing(4);
    private final Semaphore _rowFileSemaphore = new Semaphore(8);

    public BlockReadWrite(BlockStore store, Path path, boolean isEnableMmap) {
        this._store = store;
        this._blockManager = store.getBlockManager();
        this._path = path;
        this._isEnableMmap = isEnableMmap;
        if (path == null) {
            throw new NullPointerException();
        }
    }

    public long getFileSize() {
        return this._fileSize;
    }

    private void setFileSize(long fileSize) {
        if (fileSize < 0L) {
            throw new IllegalStateException(L.l("Invalid file size {0} for {1}", (Object)fileSize, (Object)this._path));
        }
        this._fileSize = fileSize;
    }

    void create() throws IOException, SQLException {
        this._path.getParent().mkdirs();
        if (this._path.getLength() > 0L) {
            throw new SQLException(L.l("CREATE for path '{0}' failed, because the file already exists.  CREATE can not override an existing table.", (Object)this._path.getNativePath()));
        }
        WriteStream os = null;
        try {
            this._path.remove();
            os = this._path.openWrite();
        }
        catch (Throwable throwable) {
            IoUtil.close(os);
            throw throwable;
        }
        IoUtil.close((OutputStream)os);
    }

    boolean isFileExist() {
        return this._path.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws IOException {
        boolean isPriority = true;
        RandomAccessWrapper wrapper = this.openRowFile(true, 0x800000L);
        try {
            RandomAccessStream file = wrapper.getFile();
            this.setFileSize(file.getLength());
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
        }
        finally {
            this.closeRowFile(wrapper, isPriority);
        }
    }

    public void removeInit() throws IOException {
        this._path.remove();
    }

    public void remove() throws SQLException {
        try {
            Path path = this._path;
            this._path = null;
            this.close();
            if (path != null) {
                path.remove();
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
    }

    public void readBlock(long blockId, byte[] buffer, int offset, int length) throws IOException {
        int retry = 10;
        while (retry-- >= 0) {
            if (!this.readBlockImpl(blockId, buffer, offset, length)) continue;
            return;
        }
        throw new IllegalStateException("Error reading for block " + Long.toHexString(blockId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readBlockImpl(long blockId, byte[] buffer, int offset, int length) throws IOException {
        long blockAddress = blockId & 0xFFFFFFFFFFFFE000L;
        boolean isPriority = false;
        RandomAccessWrapper wrapper = this.openRowFile(isPriority, blockAddress + (long)length);
        try {
            RandomAccessStream is = wrapper.getFile();
            long fileSize = is.getLength();
            if (blockAddress < 0L || fileSize < blockAddress + (long)length) {
                throw new IllegalStateException(L.l("block at 0x{0} is invalid for file {1} (length 0x{2})\n  {3}", (Object)Long.toHexString(blockAddress), (Object)this._path, (Object)Long.toHexString(fileSize), (Object)(is + ":" + is.getClass())));
            }
            int readLen = is.read(blockAddress, buffer, offset, length);
            if (readLen < 0) {
                boolean bl = false;
                return bl;
            }
            if (readLen < length) {
                System.err.println("BAD-READ: " + Long.toHexString(blockAddress));
                if (readLen < 0) {
                    readLen = 0;
                }
                for (int i = readLen; i < 8192; ++i) {
                    buffer[i] = 0;
                }
            }
            this._blockManager.addBlockRead();
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeRowFile(wrapper, isPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(long blockAddress, byte[] buffer, int offset, int length, boolean isPriority) throws IOException {
        if (buffer == null || offset < 0 || length < 0 || buffer.length < offset + length) {
            System.err.println("BUFFER: " + buffer + " " + offset + " " + length);
        }
        if (blockAddress == 0L && (buffer[offset] != 2 || buffer[offset + 2] != 2)) {
            System.err.println("Bad meta-block write: " + blockAddress + " " + buffer[offset]);
            Thread.dumpStack();
        }
        RandomAccessWrapper wrapper = this.openRowFile(isPriority, blockAddress + (long)length);
        try {
            RandomAccessStream os = wrapper.getFile();
            os.write(blockAddress, buffer, offset, length);
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
            this._blockManager.addBlockWrite();
        }
        finally {
            this.closeRowFile(wrapper, isPriority);
        }
    }

    RandomAccessStream getMmap() {
        return this._mmapFile.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsync() throws IOException {
        boolean isPriority = true;
        RandomAccessWrapper wrapper = this.openRowFile(isPriority, 0L);
        try {
            RandomAccessStream os = wrapper.getFile();
            os.fsync();
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
        }
        finally {
            this.closeRowFile(wrapper, isPriority);
        }
    }

    private RandomAccessWrapper openRowFile(boolean isPriority, long addressMax) throws IOException {
        long fileSize = this.extendFile(addressMax);
        if (!isPriority && !this._isMmap) {
            try {
                Thread.interrupted();
                this._rowFileSemaphore.acquire();
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, e.toString(), e);
                return null;
            }
        }
        RandomAccessWrapper wrapper = null;
        try {
            RandomAccessWrapper randomAccessWrapper = wrapper = this.openRowFileImpl(fileSize);
            return randomAccessWrapper;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (wrapper == null && !this._isMmap) {
                this._rowFileSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long extendFile(long addressMax) throws IOException {
        long newFileSize;
        long fileSize = this._fileSize;
        if (addressMax <= fileSize) {
            return fileSize;
        }
        for (newFileSize = fileSize; newFileSize < addressMax; newFileSize += 0x800000L) {
        }
        Object object = this._fileLock;
        synchronized (object) {
            if (this._fileSize < newFileSize) {
                RandomAccessStream stream = null;
                RandomAccessWrapper wrapper = this.openRowFileImpl(newFileSize);
                try {
                    if (wrapper != null) {
                        stream = wrapper.getFile();
                    }
                    if (stream == null) {
                        throw new IllegalStateException(this + " cannot open");
                    }
                    long fileLength = stream.getLength();
                    if (fileLength < newFileSize) {
                        stream.write(newFileSize - 1L, new byte[1], 0, 1);
                    }
                    fileLength = stream.getLength();
                    newFileSize = Math.max(newFileSize, fileLength);
                    this.freeRowFile(wrapper, false);
                    wrapper = null;
                }
                finally {
                    this.closeRowFile(wrapper, true);
                }
                this.setFileSize(newFileSize);
            }
            return this._fileSize;
        }
    }

    private RandomAccessWrapper openRowFileImpl(long fileSize) throws IOException {
        RandomAccessWrapper wrapper;
        RandomAccessStream file = this._mmapFile.get();
        if (file == null && (wrapper = (RandomAccessWrapper)this._cachedRowFile.allocate()) != null) {
            file = wrapper.getFile();
        }
        for (int count = 10; !(count <= 0 || file != null && file.allocate()); --count) {
            Path path = this._path;
            file = null;
            if (path == null) continue;
            file = this.streamOpen(fileSize);
        }
        if (file == null) {
            throw new IllegalStateException("Cannot open file");
        }
        return new RandomAccessWrapper(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessStream streamOpen(long fileSize) throws IOException {
        int retry = 8;
        if (!this._isEnableMmap) {
            RandomAccessStream file = this._path.openRandomAccess();
            return file;
        }
        while (retry-- >= 0) {
            RandomAccessStream mmapFile = this._mmapFile.get();
            if (mmapFile != null && mmapFile.isOpen() && mmapFile.getLength() == fileSize) {
                return mmapFile;
            }
            AtomicReference<RandomAccessStream> atomicReference = this._mmapFile;
            synchronized (atomicReference) {
                mmapFile = this._mmapFile.get();
                if (mmapFile != null) {
                    return mmapFile;
                }
                if (!this._mmapFile.compareAndSet(mmapFile, null)) {
                    System.err.println("INVALID-MMAP-FILE");
                }
                this.closeMmapFile(mmapFile);
                RandomAccessStream file = null;
                if (this._isEnableMmap) {
                    file = this._path.openMemoryMappedFile(fileSize);
                    if (file != null) {
                        this._isMmap = true;
                        if (this._mmapFile.compareAndSet(null, file)) {
                            return file;
                        }
                        System.err.println("CANNOT SET");
                        file.close();
                        file = null;
                    }
                    this._isEnableMmap = false;
                }
                if (!this._isEnableMmap) {
                    return this._path.openRandomAccess();
                }
            }
        }
        return null;
    }

    private void closeMmapFile(RandomAccessStream mmapFile) {
        try {
            if (mmapFile != null) {
                this._mmapFile.compareAndSet(mmapFile, null);
                mmapFile.close();
                long timeout = 15000L;
                long expires = CurrentTime.getCurrentTimeActual() + timeout;
                while (mmapFile.isOpen() && CurrentTime.getCurrentTimeActual() < expires) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void freeRowFile(RandomAccessWrapper wrapper, boolean isPriority) throws IOException {
        if (wrapper == null) {
            return;
        }
        if (!isPriority && !this._isMmap) {
            this._rowFileSemaphore.release();
        }
        wrapper.free();
        if (wrapper.getFile() == this._mmapFile.get()) {
            return;
        }
        if (this._store.isClosed() || !this._cachedRowFile.free((Object)wrapper)) {
            wrapper.close();
        }
    }

    private void closeRowFile(RandomAccessWrapper wrapper, boolean isPriority) throws IOException {
        if (wrapper == null) {
            return;
        }
        if (!isPriority && !this._isMmap) {
            this._rowFileSemaphore.release();
        }
        wrapper.closeFromException();
    }

    void close() {
        this._path = null;
        RandomAccessStream mmap = this._mmapFile.getAndSet(null);
        if (mmap != null) {
            try {
                mmap.close();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        RandomAccessWrapper wrapper = null;
        while ((wrapper = (RandomAccessWrapper)this._cachedRowFile.allocate()) != null) {
            try {
                wrapper.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._store.getId() + "," + this._store + "]";
    }

    static class RandomAccessWrapper {
        private RandomAccessStream _file;

        RandomAccessWrapper(RandomAccessStream file) {
            this._file = file;
        }

        RandomAccessStream getFile() {
            return this._file;
        }

        void free() {
            RandomAccessStream file = this._file;
            if (file != null) {
                file.free();
            }
        }

        void close() throws IOException {
            RandomAccessStream file = this._file;
            this._file = null;
            if (file != null) {
                file.close();
            }
        }

        void closeFromException() throws IOException {
            RandomAccessStream file = this._file;
            this._file = null;
            if (file != null) {
                file.free();
                file.close();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._file + "]";
        }
    }
}

