/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.BlockManagerMXBean;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyLruCache;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BlockManager
extends AbstractManagedObject
implements BlockManagerMXBean {
    private static final Logger log = Logger.getLogger(BlockManager.class.getName());
    private static final L10N L = new L10N(BlockManager.class);
    private static BlockManager _staticManager;
    private final byte[] _storeMask = new byte[8192];
    private final ConcurrentArrayList<BlockStore> _storeList = new ConcurrentArrayList(BlockStore.class);
    private LongKeyLruCache<Block> _blockCache;
    private boolean _isEnableMmap = true;
    private final AtomicLong _blockWriteCount = new AtomicLong();
    private final AtomicLong _blockReadCount = new AtomicLong();

    private BlockManager(int capacity) {
        super(ClassLoader.getSystemClassLoader());
        this._blockCache = new LongKeyLruCache(capacity);
        this._storeMask[0] = (byte)(this._storeMask[0] | 1);
        this.registerSelf();
    }

    public static synchronized BlockManager create() {
        if (_staticManager == null) {
            int minEntries = (int)BlockManager.defaultCapacity();
            _staticManager = new BlockManager(minEntries);
        }
        return _staticManager;
    }

    private static long defaultCapacity() {
        long meg = 0x100000L;
        long minSize = 1L * meg;
        long maxSize = 128L * meg;
        long maxMemory = BlockManager.getMaxMemory();
        long memorySize = maxMemory / meg / 8L * meg;
        if (memorySize < minSize) {
            memorySize = minSize;
        }
        if (maxSize < memorySize) {
            memorySize = maxSize;
        }
        int blockCount = (int)(memorySize / 8192L);
        int size = 256;
        while (2 * size <= blockCount) {
            size *= 2;
        }
        return size;
    }

    private static long getMaxMemory() {
        try {
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heap = null;
            if (memoryBean != null) {
                heap = memoryBean.getHeapMemoryUsage();
            }
            if (heap != null) {
                return Math.max(heap.getMax(), heap.getCommitted());
            }
            Runtime runtime = Runtime.getRuntime();
            return Math.max(runtime.maxMemory(), runtime.totalMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Runtime.getRuntime().maxMemory();
        }
    }

    public static BlockManager getBlockManager() {
        return _staticManager;
    }

    public void ensureCapacity(int minCapacity) {
        this._blockCache = this._blockCache.ensureCapacity(minCapacity);
    }

    public void setCapacity(int minCapacity) {
        if (minCapacity > 128) {
            this._blockCache = this._blockCache.setCapacity(minCapacity);
        }
    }

    public void ensureMemoryCapacity(long memorySize) {
        int blocks = (int)(memorySize + 8192L - 1L) / 8192;
        this.ensureCapacity(blocks);
    }

    public long getBlockCacheMemoryCapacity() {
        return this._blockCache.getCapacity() * 8192;
    }

    public boolean isEnableMmap() {
        return this._isEnableMmap;
    }

    public void setEnableMmap(boolean isEnable) {
        this._isEnableMmap = isEnable;
    }

    public int allocateStoreId() {
        byte[] byArray = this._storeMask;
        synchronized (this._storeMask) {
            for (int i = 0; i < this._storeMask.length; ++i) {
                byte mask = this._storeMask[i];
                if (mask == 255) continue;
                for (int j = 0; j < 8; ++j) {
                    if ((mask & 1 << j) != 0) continue;
                    int n = i;
                    this._storeMask[n] = (byte)(this._storeMask[n] | 1 << j);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return 8 * i + j;
                }
            }
            throw new IllegalStateException(L.l("All store ids used."));
        }
    }

    void addStore(BlockStore store) {
        this._storeList.add((Object)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(BlockStore store) {
        ArrayList<Block> dirtyBlocks = new ArrayList<Block>();
        LongKeyLruCache<Block> longKeyLruCache = this._blockCache;
        synchronized (longKeyLruCache) {
            Iterator values = this._blockCache.values();
            while (values.hasNext()) {
                Block block = (Block)values.next();
                if (block == null || block.getStore() != store || !block.isDirty()) continue;
                dirtyBlocks.add(block);
            }
        }
        for (Block block : dirtyBlocks) {
            store.getWriter().addDirtyBlock(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<Block> dirtyBlocks = new ArrayList<Block>();
        LongKeyLruCache<Block> longKeyLruCache = this._blockCache;
        synchronized (longKeyLruCache) {
            Iterator values = this._blockCache.values();
            while (values.hasNext()) {
                Block block = (Block)values.next();
                if (!block.isDirty()) continue;
                dirtyBlocks.add(block);
            }
        }
        for (Block block : dirtyBlocks) {
            BlockStore store = block.getStore();
            store.getWriter().addDirtyBlock(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeStore(BlockStore store) {
        this._storeList.remove((Object)store);
        ArrayList<Block> removeBlocks = new ArrayList<Block>();
        LongKeyLruCache<Block> longKeyLruCache = this._blockCache;
        synchronized (longKeyLruCache) {
            Iterator iter = this._blockCache.values();
            while (iter.hasNext()) {
                Block block = (Block)iter.next();
                if (block == null || block.getStore() != store) continue;
                removeBlocks.add(block);
            }
        }
        for (Block block : removeBlocks) {
            this._blockCache.remove(block.getBlockId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeStoreId(int storeId) {
        byte[] byArray = this._storeMask;
        synchronized (this._storeMask) {
            if (storeId <= 0) {
                throw new IllegalArgumentException(String.valueOf(storeId));
            }
            int n = storeId / 8;
            this._storeMask[n] = (byte)(this._storeMask[n] & ~(1 << storeId % 8));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void destroy() {
        for (BlockStore store : (BlockStore[])this._storeList.toArray()) {
            try {
                store.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    Block getBlock(BlockStore store, long blockId) {
        long storeId = blockId & 0x1FFFL;
        if (storeId != (long)store.getId()) {
            throw BlockManager.stateError("illegal block: " + Long.toHexString(blockId));
        }
        Block block = (Block)this._blockCache.get(blockId);
        while (block == null || !block.allocate()) {
            block = new Block(store, blockId);
            Block oldBlock = (Block)this._blockCache.putIfAbsent(blockId, (Object)block);
            if (oldBlock == null) continue;
            block.free();
            block = oldBlock;
        }
        if (blockId != block.getBlockId() || (blockId & 0x1FFFL) != (long)store.getId() || block.getStore() != store) {
            throw BlockManager.stateError("BLOCK: " + Long.toHexString(blockId) + " " + Long.toHexString(block.getBlockId()) + " " + store + " " + block.getStore());
        }
        return block;
    }

    final boolean copyDirtyBlock(Block block) {
        BlockStore store = block.getStore();
        long blockId = block.getBlockId();
        return store.getWriter().copyDirtyBlock(blockId, block);
    }

    public void clear() {
        this._blockCache.clear();
    }

    public String getName() {
        return null;
    }

    public String getType() {
        return "BlockManager";
    }

    @Override
    public long getBlockCapacity() {
        return this._blockCache.getCapacity();
    }

    @Override
    public long getMemorySize() {
        return this._blockCache.getCapacity() * 8192;
    }

    @Override
    public long getHitCountTotal() {
        return this._blockCache.getHitCount();
    }

    @Override
    public long getMissCountTotal() {
        return this._blockCache.getMissCount();
    }

    @Override
    public double getMissRate() {
        long missCount = this.getMissCountTotal();
        long hitCount = this.getHitCountTotal();
        double accessCount = hitCount + missCount;
        if (accessCount == 0.0) {
            accessCount = 1.0;
        }
        return (double)missCount / accessCount;
    }

    final void addBlockRead() {
        this._blockReadCount.incrementAndGet();
    }

    @Override
    public long getBlockReadCountTotal() {
        return this._blockReadCount.get();
    }

    final void addBlockWrite() {
        this._blockWriteCount.incrementAndGet();
    }

    @Override
    public long getBlockWriteCountTotal() {
        return this._blockWriteCount.get();
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }
}

