/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cluster;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.env.vote.AbstractVoteManager;
import com.caucho.env.vote.VoteService;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
@Configurable
public class ClusterVoteManager {
    private static final L10N L = new L10N(ClusterVoteManager.class);
    private AbstractVoteManager _manager;
    private String _name;
    private String _guid;
    private boolean _isInit;

    public ClusterVoteManager() {
    }

    public ClusterVoteManager(String name) {
        this.setName(name);
        this.init();
    }

    public String getName() {
        return this._name;
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    public void setGuid(String guid) {
        this._guid = guid;
    }

    public ClusterServer electServer(String name) {
        return this._manager.electServer(this._guid, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        ClusterVoteManager clusterVoteManager = this;
        synchronized (clusterVoteManager) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            this.initServer();
            this.initName(this._name);
        }
    }

    private void initName(String name) throws ConfigException {
        if (this._name == null || this._name.length() == 0) {
            throw new ConfigException(L.l("'{0}' requires a name because each vote manager must be identified uniquely.", (Object)this.getClass().getSimpleName()));
        }
        String contextId = Environment.getEnvironmentName();
        if (this._guid == null) {
            this._guid = contextId + ":" + this._name;
        }
    }

    private void initServer() throws ConfigException {
        VoteService voteService = VoteService.getCurrent();
        if (voteService == null) {
            throw new ConfigException(L.l("'{0}' requires an active {1}", (Object)this.getClass().getSimpleName(), (Object)VoteService.class.getSimpleName()));
        }
        this._manager = voteService.getManager();
        if (this._manager == null) {
            throw new IllegalStateException(L.l("distributed vote manager not available"));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }
}

