/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cluster;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.env.lock.LockManager;
import com.caucho.env.lock.LockService;
import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.PostConstruct;

@Module
public abstract class AbstractLock
implements Lock {
    private static final L10N L = new L10N(AbstractLock.class);
    private LockManager _manager;
    private Lock _lock;
    private String _name;
    private String _guid;
    private boolean _isInit;

    public String getName() {
        return this._name;
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    public void setGuid(String guid) {
        this._guid = guid;
    }

    @Override
    public void lock() {
        this._lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this._lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this._lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this._lock.tryLock(time, unit);
    }

    @Override
    public void unlock() {
        this._lock.unlock();
    }

    @Override
    public Condition newCondition() {
        return this._lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        AbstractLock abstractLock = this;
        synchronized (abstractLock) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            this.initServer();
            this.initName(this._name);
            this._lock = this._manager.getOrCreateLock(this._guid);
            assert (this._lock != null);
        }
    }

    private void initName(String name) throws ConfigException {
        if (this._name == null || this._name.length() == 0) {
            throw new ConfigException(L.l("'{0}' requires a name because each lock must be identified uniquely.", (Object)this.getClass().getSimpleName()));
        }
        String contextId = Environment.getEnvironmentName();
        if (this._guid == null) {
            this._guid = contextId + ":" + this._name;
        }
    }

    private void initServer() throws ConfigException {
        LockService lockService = LockService.getCurrent();
        if (lockService == null) {
            throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a Resin environment\n  {1}", (Object)this.getClass().getSimpleName(), (Object)Thread.currentThread().getContextClassLoader()));
        }
        this._manager = lockService.getManager();
        if (this._manager == null) {
            throw new IllegalStateException("distributed lock manager not available");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }
}

