/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;

public class TopologyService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 40;
    private static final L10N L = new L10N(TopologyService.class);
    private final String _serverId;
    private final CloudSystem _system;

    public TopologyService(String serverId) {
        this._serverId = serverId;
        this._system = new CloudSystem(serverId);
    }

    public static TopologyService createAndAddService(String serverId) {
        ResinSystem system = TopologyService.preCreate(TopologyService.class);
        TopologyService service = new TopologyService(serverId);
        system.addService(TopologyService.class, (ResinSubSystem)service);
        return service;
    }

    public static TopologyService getCurrent() {
        return (TopologyService)ResinSystem.getCurrentService(TopologyService.class);
    }

    public static CloudSystem getCurrentSystem() {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("{0} needs an active {1}", (Object)TopologyService.class.getSimpleName(), (Object)ResinSystem.class.getSimpleName()));
        }
        return topology.getSystem();
    }

    public static CloudCluster findCluster(String id) {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("TopologyService must be active in the ResinSystem"));
        }
        return topology.getSystem().findCluster(id);
    }

    public static CloudServer findServer(String id) {
        TopologyService topology = TopologyService.getCurrent();
        if (topology == null) {
            throw new IllegalStateException(L.l("TopologyService must be active in the ResinSystem"));
        }
        return topology.getSystem().findServer(id);
    }

    public CloudSystem getSystem() {
        return this._system;
    }

    public String getId() {
        return this._serverId;
    }

    public CloudServer getSelfServer() {
        return this._system.findServer(this._serverId);
    }

    public int getStartPriority() {
        return 40;
    }

    public void start() {
        this._system.start();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this._system + "]";
    }
}

