/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.loadbalance;

import com.caucho.cloud.loadbalance.CustomLoadBalanceManager;
import com.caucho.config.ConfigException;
import com.caucho.network.balance.ClientSocket;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.util.L10N;

public class SingleLoadBalanceManager
extends CustomLoadBalanceManager {
    private static final L10N L = new L10N(SingleLoadBalanceManager.class);
    private ClientSocketFactory _serverPool;

    public SingleLoadBalanceManager(ClientSocketFactory serverPool, String probeCategory) {
        super(probeCategory);
        this._serverPool = serverPool;
    }

    public SingleLoadBalanceManager(String probeCategory) {
        super(probeCategory);
    }

    @Override
    public void addAddress(String address) {
        if (this._serverPool != null) {
            throw new ConfigException(L.l("Multiple backend load balancing requires Resin Professional."));
        }
        this._serverPool = this.createServerPool(address);
    }

    public void init() {
        if (this._serverPool == null) {
            throw new ConfigException(L.l("Load-balancing requires at least one server address."));
        }
    }

    @Override
    public ClientSocket openSticky(String sessionId, Object requestInfo, ClientSocketFactory oldSrun) {
        if (this._serverPool == oldSrun) {
            return null;
        }
        return this._serverPool.open();
    }
}

