/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.admin.RemoteAdminService;
import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.JniBoot;
import com.caucho.boot.WatchdogActor;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogConfigHandle;
import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.core.ResinProperties;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.config.types.Period;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DependencyCheckInterval;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.LogHandlerConfig;
import com.caucho.log.RotateStream;
import com.caucho.network.listen.TcpPort;
import com.caucho.security.AdminAuthenticator;
import com.caucho.security.Authenticator;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.http.HttpProtocol;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ResinArgs;
import com.caucho.server.resin.ResinELContext;
import com.caucho.server.resin.ResinWatchdog;
import com.caucho.server.util.JniCauchoSystem;
import com.caucho.server.webbeans.ResinServerConfigLibrary;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class WatchdogManager
implements AlarmListener {
    private static L10N _L;
    private static Logger _log;
    private static WatchdogManager _watchdog;
    private Lifecycle _lifecycle = new Lifecycle();
    private WatchdogArgs _args;
    private int _watchdogPort;
    private String _adminCookie;
    private BootResinConfig _resinConfig;
    private BootManagementConfig _management;
    private final ResinSystem _system;
    private ServletService _server;
    private TcpPort _httpPort;
    private HashMap<String, WatchdogChild> _watchdogMap = new HashMap();

    WatchdogManager(String[] argv) throws Exception {
        _watchdog = this;
        this._args = new WatchdogArgs(argv);
        String serverId = this._args.getServerId();
        if (serverId == null) {
            serverId = this._args.getClientServerId();
        }
        ResinArgs resinArgs = new ResinArgs();
        resinArgs.setRootDirectory(this._args.getRootDirectory());
        resinArgs.setServerId(serverId);
        if (this._args.getDataDirectory() != null) {
            resinArgs.setDataDirectory(this._args.getDataDirectory());
        }
        ResinWatchdog resin = new ResinWatchdog(resinArgs);
        this._system = resin.getResinSystem();
        Vfs.setPwd((Path)this._args.getRootDirectory());
        Path logPath = this.getLogDirectory().lookup("watchdog-manager.log");
        try {
            this.getLogDirectory().mkdirs();
        }
        catch (Exception e) {
            WatchdogManager.log().log(Level.ALL, e.toString(), e);
        }
        WriteStream testOut = logPath.openAppend();
        testOut.close();
        if (!logPath.canWrite()) {
            throw new ConfigException("Cannot open " + logPath.getNativePath() + " required for Resin start. Please check permissions");
        }
        RotateStream logStream = RotateStream.create((Path)logPath);
        logStream.setRolloverSize(0x4000000L);
        logStream.init();
        WriteStream out = logStream.getStream();
        out.setDisableClose(true);
        EnvironmentStream.setStdout((OutputStream)out);
        EnvironmentStream.setStderr((OutputStream)out);
        LogHandlerConfig log = new LogHandlerConfig();
        log.setName("");
        log.setPath(logPath);
        log.init();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader((ClassLoader)this._system.getClassLoader());
        ThreadPool.getThreadPool().setIdleMin(8);
        ThreadPool.getThreadPool().setPriorityIdleMin(8);
        ThreadPool.getThreadPool().setIdleMax(16);
        ThreadPool.getThreadPool().setIdleTimeout(Integer.MAX_VALUE);
        ResinELContext elContext = this._args.getELContext();
        InjectManager cdiManager = InjectManager.create();
        Config.setProperty((String)"resinHome", (Object)elContext.getResinHome());
        Config.setProperty((String)"resin", (Object)elContext.getResinVar());
        Config.setProperty((String)"server", (Object)elContext.getServerVar());
        Config.setProperty((String)"java", (Object)elContext.getJavaVar());
        Config.setProperty((String)"system", (Object)System.getProperties());
        Config.setProperty((String)"getenv", System.getenv());
        Config.setProperty((String)"rvar0", (Object)serverId);
        ResinConfigLibrary.configure((InjectManager)cdiManager);
        ResinServerConfigLibrary.configure(cdiManager);
        if (this._args.getUserProperties() != null && this._args.getUserProperties().canRead()) {
            ResinProperties properties = new ResinProperties();
            properties.setPath(this._args.getUserProperties());
            properties.setMode(this._args.getMode());
            properties.init();
        }
        this._watchdogPort = this._args.getWatchdogPort();
        this._resinConfig = this.readConfig(this._args);
        WatchdogChild server = this.findConfig(this._resinConfig, serverId, this._args);
        if ((server = this.getWatchdog(server, serverId, this._args)) == null) {
            if (serverId == null) {
                throw new IllegalStateException(WatchdogManager.L().l("Cannot find any <server> or <server-multi> matching a local IP address"));
            }
            throw new IllegalStateException(WatchdogManager.L().l("'{0}' is an unknown server", (Object)serverId));
        }
        boolean isLogDirectoryExists = this.getLogDirectory().exists();
        JniBoot boot = new JniBoot();
        Path logDirectory = this.getLogDirectory();
        if (boot.isValid() && !isLogDirectoryExists) {
            logDirectory.mkdirs();
            boot.chown(logDirectory, server.getUserName(), server.getGroupName());
        }
        server.getConfig().logInit(logStream);
        this.startWatchdogSystem(resin, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWatchdogSystem(Resin resin, WatchdogChild server) throws Exception {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader((ClassLoader)resin.getClassLoader());
        this._server = resin.createServer();
        thread.setContextClassLoader((ClassLoader)this._server.getClassLoader());
        NetworkListenSystem listenService = (NetworkListenSystem)this._system.getService(NetworkListenSystem.class);
        this._httpPort = new TcpPort();
        this._httpPort.setProtocol(new HttpProtocol());
        if (this._watchdogPort > 0) {
            this._httpPort.setPort(this._watchdogPort);
        } else {
            this._httpPort.setPort(server.getWatchdogPort());
        }
        this._httpPort.setAddress(server.getWatchdogAddress());
        this._httpPort.setAcceptThreadMin(2);
        this._httpPort.setAcceptThreadMax(3);
        this._httpPort.init();
        listenService.addListener(this._httpPort);
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this._system.getClassLoader());
            InjectManager cdiManager = InjectManager.create();
            AdminAuthenticator auth = null;
            if (this._management != null) {
                auth = this._management.getAdminAuthenticator();
            }
            if (auth != null) {
                BeanBuilder factory = cdiManager.createBeanFactory(Authenticator.class);
                factory.type(new Type[]{Authenticator.class});
                factory.type(new Type[]{AdminAuthenticator.class});
                factory.qualifier((Annotation)DefaultLiteral.DEFAULT);
                cdiManager.addBeanDiscover(factory.singleton((Object)auth));
            }
            DependencyCheckInterval depend = new DependencyCheckInterval();
            depend.setValue(new Period(-1L));
            depend.init();
            RemoteAdminService adminService = new RemoteAdminService();
            adminService.setAuthenticationRequired(false);
            adminService.init();
            HempBroker broker = HempBroker.getCurrent();
            WatchdogActor service = new WatchdogActor(this);
            broker.getBamManager().createService("watchdog@admin.resin.caucho", service);
            ResinSystem.getCurrent().start();
            this._lifecycle.toActive();
            new Alarm((AlarmListener)this).queue(60000L);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    ClassLoader getClassLoader() {
        return this._system.getClassLoader();
    }

    static WatchdogManager getWatchdog() {
        return _watchdog;
    }

    public void setAdminCookie(String cookie) {
        if (this._adminCookie == null) {
            this._adminCookie = cookie;
        }
    }

    public String getAdminCookie() {
        if (this._adminCookie != null) {
            return this._adminCookie;
        }
        if (this._management != null) {
            return this._management.getAdminCookie();
        }
        return null;
    }

    boolean isActive() {
        return this._server.isActive() && this._httpPort.isActive();
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    Path getRootDirectory() {
        return this._args.getRootDirectory();
    }

    Path getResinHome() {
        return this._args.getResinHome();
    }

    Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    boolean authenticate(String password) {
        String cookie = this.getAdminCookie();
        if (password == null && cookie == null) {
            return true;
        }
        return password != null && password.equals(cookie);
    }

    WatchdogChild findServer(String id) {
        return this._watchdogMap.get(id);
    }

    BootResinConfig getManagerConfig() {
        return this._resinConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String status() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            ArrayList<String> keys = new ArrayList<String>(this._watchdogMap.keySet());
            Collections.sort(keys);
            sb.append("\nwatchdog:\n");
            sb.append("  watchdog-pid: " + this.getWatchdogPid());
            for (String key : keys) {
                WatchdogChild child = this._watchdogMap.get(key);
                sb.append("\n\n");
                sb.append("server '" + child.getId() + "' : " + child.getState() + "\n");
                if (this.getAdminCookie() == null) {
                    sb.append("  password: missing\n");
                } else {
                    sb.append("  password: ok\n");
                }
                sb.append("  watchdog-user: " + System.getProperty("user.name") + "\n");
                if (child.getUserName() != null) {
                    sb.append("  user: " + child.getUserName());
                } else {
                    sb.append("  user: " + System.getProperty("user.name"));
                }
                if (child.getGroupName() != null) {
                    sb.append("(" + child.getGroupName() + ")");
                }
                sb.append("\n");
                sb.append("  root: " + child.getResinRoot() + "\n");
                sb.append("  conf: " + child.getResinConf() + "\n");
                if (child.getPid() > 0) {
                    sb.append("  pid: " + child.getPid() + "\n");
                }
                sb.append("  uptime: " + child.getUptimeString() + "\n");
            }
        }
        return sb.toString();
    }

    String startServerAll(String cliServerId, String[] argv) throws ConfigException {
        WatchdogChild server;
        WatchdogArgs args = new WatchdogArgs(argv, null, false);
        Vfs.setPwd((Path)this._args.getRootDirectory());
        String serverId = args.getServerId();
        try {
            BootResinConfig resin = this.readConfig(args);
            if (resin.isElasticServer()) {
                int totalCount = 0;
                for (BootResinConfig.ElasticServer elasticServer : resin.getElasticServers()) {
                    String cluster = elasticServer.getCluster();
                    int count = elasticServer.getCount();
                    for (int index = 0; index < count; ++index) {
                        WatchdogChild server2 = this.addElasticServer(resin, args, cluster, index, totalCount);
                        this.startServer(server2, serverId, args);
                        ++totalCount;
                    }
                }
                return "test";
            }
            server = this.findConfig(resin, serverId, args);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        this.startServer(server, serverId, args);
        return serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String startServer(String cliServerId, String[] argv) throws ConfigException {
        String serverId = cliServerId;
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild server;
            WatchdogArgs args = new WatchdogArgs(argv, null, false);
            Vfs.setPwd((Path)this._args.getRootDirectory());
            if (serverId == null) {
                serverId = args.getServerId();
            }
            try {
                BootResinConfig resin = this.readConfig(args);
                server = this.findConfig(resin, serverId, args);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            this.startServer(server, serverId, args);
        }
        return serverId;
    }

    void startServer(WatchdogChild watchdog, String serverId, WatchdogArgs args) {
        if ((watchdog = this.getWatchdog(watchdog, serverId, args)) == null) {
            throw new ConfigException(WatchdogManager.L().l("No matching <server> found for start -server '{0}' in '{1}'", (Object)serverId, (Object)this._args.getResinConf()));
        }
        watchdog.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServer(String serverId, String[] argv) {
        WatchdogArgs args = new WatchdogArgs(argv, false);
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild watchdog = this.getWatchdog(null, serverId, args);
            if (watchdog == null) {
                throw new ConfigException(WatchdogManager.L().l("No matching <server> found for stop -server '{0}' in {1}", (Object)serverId, (Object)this._args.getResinConf()));
            }
            watchdog.stop();
        }
    }

    private void stopServer(WatchdogChild watchdog) {
        watchdog.stop();
    }

    WatchdogChild getWatchdog(WatchdogChild watchdog, String serverId, WatchdogArgs args) {
        if (watchdog != null) {
            return watchdog;
        }
        if (serverId == null) {
            watchdog = this.findLocalServer();
        }
        if (serverId == null) {
            serverId = "default";
        }
        String defaultServerId = this.getServerId(serverId, args);
        if (watchdog == null) {
            watchdog = this.getWatchdog(defaultServerId);
        }
        if (watchdog == null && (watchdog = this.getWatchdog(serverId)) == null) {
            watchdog = this._watchdogMap.get(defaultServerId);
        }
        return watchdog;
    }

    private String getServerId(String serverId, WatchdogArgs args) {
        if (serverId == null && !this.isDynamicServer(args)) {
            serverId = args.getServerId();
        } else if (serverId == null && this.isDynamicServer(args)) {
            serverId = args.getElasticServerId();
        }
        if (serverId == null) {
            serverId = "default";
        }
        return serverId;
    }

    private boolean isDynamicServer(WatchdogArgs args) {
        return args.isElasticServer();
    }

    private WatchdogChild getWatchdog(String serverId) {
        WatchdogChild watchdog = this._watchdogMap.get(serverId);
        if (watchdog == null && (serverId == null || "".equals(serverId)) && this._watchdogMap.size() == 1) {
            watchdog = this._watchdogMap.values().iterator().next();
        }
        return watchdog;
    }

    void killServer(String serverId) {
        WatchdogChild watchdog = this.getWatchdog(serverId);
        if (watchdog == null) {
            throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in {1}", (Object)serverId, (Object)this._args.getResinConf()));
        }
        watchdog.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            for (WatchdogChild child : this._watchdogMap.values()) {
                if (!child.isActive()) continue;
                return false;
            }
        }
        return true;
    }

    void shutdown() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this._watchdogMap.keySet());
        for (String serverId : keys) {
            this.stopServer(this._watchdogMap.get(serverId));
            this.killServer(serverId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartServer(String serverId, String[] argv) {
        WatchdogArgs args = new WatchdogArgs(argv, false);
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild watchdog = this.getWatchdog(null, serverId, args);
            if (watchdog != null) {
                watchdog.stop();
            }
            this.startServer(serverId, argv);
        }
    }

    boolean isValid() {
        return this._server != null && this._server.isActive();
    }

    private BootResinConfig readConfig(WatchdogArgs args) throws Exception {
        Config config = new Config();
        config.setIgnoreEnvironment(true);
        Vfs.setPwd((Path)args.getRootDirectory());
        BootResinConfig resin = new BootResinConfig(this._system, args);
        Config.setProperty((String)"rvar0", (Object)args.getServerId());
        config.configure((Object)resin, args.getResinConf(), "com/caucho/server/resin/resin.rnc");
        if (this._management == null) {
            this._management = resin.getManagement();
        }
        return resin;
    }

    private WatchdogChild findConfig(BootResinConfig resin, String cliServerId, WatchdogArgs args) {
        WatchdogClient client = this.findClient(resin, cliServerId, args);
        if (client == null) {
            throw new ConfigException(WatchdogManager.L().l("server '{0}' cannot be started because no configuration has been found.", (Object)(cliServerId != null ? cliServerId : "")));
        }
        WatchdogChild watchdog = new WatchdogChild(this._system, client.getConfig());
        this.updateChild(watchdog);
        return watchdog;
    }

    private WatchdogClient findClient(BootResinConfig resin, String cliServerId, WatchdogArgs args) {
        Iterator<BootResinConfig.ElasticServer> iterator;
        String serverId = resin.getServerId(args);
        WatchdogClient client = resin.findClient(cliServerId, args);
        if (client != null) {
            return client;
        }
        if (!resin.isElasticServer(args)) {
            if (serverId != null) {
                return null;
            }
            client = resin.findUniqueLocalClient(cliServerId, args);
            if (client != null) {
                return client;
            }
        }
        if (resin.isDynamicServerAllowed(args) && (iterator = resin.getElasticServerList().iterator()).hasNext()) {
            BootResinConfig.ElasticServer server = iterator.next();
            return this.addElasticServerChild(resin, args, server.getCluster(), 0, 0);
        }
        return null;
    }

    private WatchdogChild addElasticServer(BootResinConfig resin, WatchdogArgs args, String cluster, int index, int totalCount) {
        WatchdogClient client = this.addElasticServerChild(resin, args, cluster, index, totalCount);
        WatchdogChild watchdog = new WatchdogChild(this._system, client.getConfig());
        this.updateChild(watchdog);
        return watchdog;
    }

    private WatchdogClient addElasticServerChild(BootResinConfig resin, WatchdogArgs args, String clusterId, int index, int totalCount) {
        if (clusterId == null) {
            clusterId = resin.getClusterId(args);
        }
        String address = args.getDynamicAddress();
        int port = resin.getElasticServerPort(args, totalCount);
        BootClusterConfig cluster = resin.findCluster(clusterId);
        if (cluster == null) {
            throw new ConfigException(WatchdogManager.L().l("server cannot be started because '{0}' is an unknown cluster", (Object)clusterId));
        }
        clusterId = cluster.getId();
        String serverId = args.getServerId();
        if (serverId == null) {
            serverId = "dyn-" + clusterId + "-" + index;
        } else if (totalCount > 1) {
            throw new ConfigException(WatchdogManager.L().l("--elastic-server with --server '{0}' and multiple elastic servers is not allowed.", (Object)serverId));
        }
        WatchdogConfigHandle configHandle = cluster.createServer();
        configHandle.setId(serverId);
        configHandle.setAddress(address);
        configHandle.setPort(port);
        WatchdogConfig serverConfig = cluster.addServer(configHandle);
        serverConfig.setElastic(true);
        serverConfig.setElasticServerCluster(clusterId);
        serverConfig.setElasticServerPort(port);
        return resin.findClient(serverConfig.getId());
    }

    private WatchdogChild updateChild(WatchdogChild newWatchdog) {
        String serverId = newWatchdog.getId();
        WatchdogChild oldWatchdog = this._watchdogMap.get(serverId);
        if (oldWatchdog != null) {
            if (oldWatchdog.isActive()) {
                throw new ConfigException(WatchdogManager.L().l("server '{0}' cannot be started because a running instance already exists.  stop or restart the old server first.", (Object)serverId));
            }
            oldWatchdog = this._watchdogMap.remove(serverId);
            if (oldWatchdog != null) {
                oldWatchdog.close();
            }
        }
        this._watchdogMap.put(serverId, newWatchdog);
        return newWatchdog;
    }

    private int getWatchdogPid() {
        try {
            MBeanServer server = Jmx.getGlobalMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Runtime");
            String runtimeName = (String)server.getAttribute(objName, "Name");
            if (runtimeName == null) {
                return 0;
            }
            int p = runtimeName.indexOf(64);
            if (p > 0) {
                int pid = Integer.parseInt(runtimeName.substring(0, p));
                return pid;
            }
            return 0;
        }
        catch (Exception e) {
            WatchdogManager.log().log(Level.FINE, e.toString(), e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        while (this._lifecycle.isActive()) {
            try {
                WatchdogManager watchdogManager = this;
                synchronized (watchdogManager) {
                    this.wait();
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private WatchdogChild findLocalServer() {
        ArrayList<InetAddress> localAddresses = BootResinConfig.getLocalAddresses();
        for (WatchdogChild child : this._watchdogMap.values()) {
            if (!BootResinConfig.isLocalClient(localAddresses, child.getConfig())) continue;
            return child;
        }
        return null;
    }

    private WatchdogChild findUniqueLocalServer() {
        ArrayList<InetAddress> localAddresses = BootResinConfig.getLocalAddresses();
        WatchdogChild server = null;
        for (WatchdogChild child : this._watchdogMap.values()) {
            if (!BootResinConfig.isLocalClient(localAddresses, child.getConfig())) continue;
            if (server != null) {
                return null;
            }
            server = child;
        }
        return server;
    }

    public void handleAlarm(Alarm alarm) {
        try {
            if (!this._args.getResinConf().canRead()) {
                WatchdogManager.log().severe(WatchdogManager.L().l("{0} exiting because '{1}' is no longer valid", (Object)this, (Object)this._args.getResinConf()));
                System.exit(1);
            }
        }
        finally {
            alarm.queue(60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        boolean isValid = false;
        try {
            DynamicClassLoader.setJarCacheEnabled((boolean)false);
            DynamicClassLoader.setGlobalDependencyCheckInterval((long)-1L);
            JniCauchoSystem.create().initJniBackground();
            WatchdogManager manager = new WatchdogManager(argv);
            WatchdogArgs args = manager.getArgs();
            args.getCommand().doWatchdogStart(manager);
            boolean bl = isValid = manager.isActive() && manager.isValid();
            if (isValid) {
                manager.waitForExit();
            }
        }
        catch (Exception e) {
            WatchdogManager.log().log(Level.WARNING, e.toString(), e);
            System.out.println(e);
            e.printStackTrace();
        }
        finally {
            System.exit(1);
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(WatchdogManager.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(WatchdogManager.class.getName());
        }
        return _log;
    }
}

